package com.atlassian.seraph.config;

import com.atlassian.seraph.auth.Authenticator;
import com.atlassian.seraph.auth.RoleMapper;
import com.atlassian.seraph.auth.AuthenticationContext;
import com.atlassian.seraph.controller.SecurityController;

import java.util.List;

public interface SecurityConfig
{
    String STORAGE_KEY = "seraph_config";
    String BASIC_AUTH = "basic";

    List getServices();

    String getLoginURL();

    String getLinkLoginURL();

    String getLogoutURL();

    String getOriginalURLKey();

    Authenticator getAuthenticator();

    AuthenticationContext getAuthenticationContext();

    SecurityController getController();

    RoleMapper getRoleMapper();

    List getInterceptors(Class desiredInterceptorClass);

    String getCookieEncoding();


    /**
     * @return The path to use for the autologin cookie
     */
    String getLoginCookiePath();

    String getLoginCookieKey();

    void destroy();

    String getAuthType();

    boolean isInsecureCookie();

    /**
     * Autologin cookie age in seconds
     */
    int getAutoLoginCookieAge();
}
