package com.atlassian.seraph.auth;

import com.atlassian.seraph.util.GroupCache;
import com.atlassian.seraph.config.SecurityConfig;

import javax.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.Map;
import java.security.Principal;

/**
 * A simple RoleMapper which maps directly between group names and role names.
 *
 * If a user is a member of someGroup, the are in the 'someGroup' role.  Users can log in if they exist.
 */
public class GroupRoleMapper implements RoleMapper
{
    public void init(Map params, SecurityConfig config)
    {
    }

    /**
     * Assume that roles == groups.
     */
    public boolean hasRole(Principal user, HttpServletRequest request, String role)
    {
        Collection groups = GroupCache.getGroups(request);

        if (groups == null && role == null)
            return true;
        else if (groups == null)
            return false;
        else
            return groups.contains(role);
    }

    /**
     * Users can login if they exist.

     */
    public boolean canLogin(Principal user, HttpServletRequest request)
    {
        return user != null;
    }
}
