package com.atlassian.seraph.auth;

import com.atlassian.seraph.config.SecurityConfig;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.Map;
import java.security.Principal;

/**
 * An abstract implementation of Authenticator that implements a lot of base methods 
 */
public abstract class AbstractAuthenticator implements Authenticator, Serializable
{
    private Map params;
    private SecurityConfig config;

    public void init(Map params, SecurityConfig config)
    {
        this.params = params;
        this.config = config;
    }

    public void destroy()
    {
    }

    /** @deprecated Use {@link RoleMapper} directly */
    public abstract boolean isUserInRole(HttpServletRequest request, String role);

    public String getRemoteUser(HttpServletRequest request)
    {
        Principal user = getUser(request);

        if (user == null)
            return null;

        return user.getName();
    }

    public Principal getUser(HttpServletRequest request)
    {
        return getUser(request, null);
    }

    public abstract Principal getUser(HttpServletRequest request, HttpServletResponse response);

    public boolean login(HttpServletRequest request, HttpServletResponse response, String username, String password) throws AuthenticatorException
    {
        return login(request, response, username, password, false);

    }

    public abstract boolean login(HttpServletRequest request, HttpServletResponse response, String username, String password, boolean cookie) throws AuthenticatorException;

    public abstract boolean logout(HttpServletRequest request, HttpServletResponse response) throws AuthenticatorException;

    protected SecurityConfig getConfig() {
        return config;
    }
}
