/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.seraph.cookie;

import com.atlassian.seraph.config.SecurityConfigFactory;
import com.atlassian.seraph.cookie.CookieEncoder;
import com.atlassian.seraph.util.CookieUtils;
import com.atlassian.seraph.util.EncryptionUtils;
import org.apache.log4j.Category;

public class EncryptedCookieEncoder
implements CookieEncoder {
    public static final String SEPARATOR = "^^^";
    private static final Category LOG = Category.getInstance((Class)EncryptedCookieEncoder.class);
    private EncryptionUtils encryptionUtils = new EncryptionUtils();

    public EncryptedCookieEncoder() {
        this(SecurityConfigFactory.getInstance().getCookieEncoding());
    }

    protected EncryptedCookieEncoder(String password) {
        if (password == null || password.length() == 0) {
            throw new IllegalArgumentException("The password must be specified");
        }
        this.encryptionUtils.setPassword(password);
    }

    public String encodePasswordCookie(String username, String password, String encoding) {
        StringBuffer sb = new StringBuffer();
        sb.append(username).append(SEPARATOR).append(password);
        return this.encryptionUtils.encrypt(sb.toString());
    }

    public String[] decodePasswordCookie(String cookieVal, String encoding) {
        String[] result = new String[2];
        try {
            String text = this.encryptionUtils.decrypt(cookieVal);
            int pos = text.indexOf(SEPARATOR);
            if (pos < 0) {
                LOG.info((Object)("Successfully decrypted password cookie, but decrypted value '" + text + "' is invalid because separator ('" + SEPARATOR + "') was not found. Returning null."));
                return null;
            }
            result[0] = text.substring(0, pos);
            result[1] = text.substring(pos + SEPARATOR.length());
        }
        catch (RuntimeException ex) {
            LOG.info((Object)"Password cookie could not be decrypted, trying old insecure method of decoding it");
            return CookieUtils.decodePasswordCookie(cookieVal, encoding);
        }
        return result;
    }
}

