/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.security.auth.trustedapps;

import com.atlassian.security.auth.trustedapps.IPAddressFormatException;
import com.atlassian.security.auth.trustedapps.IPMatcher;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class DefaultIPMatcher
implements IPMatcher {
    private static final String WILDCARD = "*";
    private final List addressMasks = new LinkedList();

    public DefaultIPMatcher(Set patterns) throws IPAddressFormatException {
        Iterator iterator = patterns.iterator();
        while (iterator.hasNext()) {
            String patternStr = (String)iterator.next();
            int[] pattern = this.parsePatternString(patternStr);
            this.addressMasks.add(AddressMask.create(pattern));
        }
    }

    private int[] parsePatternString(String patternStr) {
        int[] pattern = new int[4];
        StringTokenizer st = new StringTokenizer(patternStr, ".");
        if (st.countTokens() != 4) {
            throw new IPAddressFormatException(patternStr);
        }
        for (int i = 0; i < 4; ++i) {
            String token = st.nextToken().trim();
            if (WILDCARD.equals(token)) {
                pattern[i] = -1;
                continue;
            }
            try {
                int value = Integer.valueOf(token);
                if (value < 0 || value > 255) {
                    throw new IPAddressFormatException(patternStr);
                }
                pattern[i] = value;
                continue;
            }
            catch (NumberFormatException e) {
                throw new IPAddressFormatException(patternStr);
            }
        }
        return pattern;
    }

    public boolean match(String ipAddress) {
        if (this.addressMasks.isEmpty()) {
            return true;
        }
        int address = this.toAddress(ipAddress);
        Iterator iterator = this.addressMasks.iterator();
        while (iterator.hasNext()) {
            AddressMask addressMask = (AddressMask)iterator.next();
            if (!addressMask.matches(address)) continue;
            return true;
        }
        return false;
    }

    private int toAddress(String ipAddress) {
        int address = 0;
        int[] parsedIPAddr = this.parsePatternString(ipAddress);
        for (int i = 0; i < parsedIPAddr.length; ++i) {
            address <<= 8;
            address |= parsedIPAddr[i];
        }
        return address;
    }

    private static class AddressMask {
        private final int address;
        private final int mask;

        public AddressMask(int address, int mask) {
            this.address = address;
            this.mask = mask;
        }

        public boolean matches(int otherAddress) {
            return this.address == (otherAddress & this.mask);
        }

        static AddressMask create(int[] pattern) {
            int address = 0;
            int mask = 0;
            for (int i = 0; i < pattern.length; ++i) {
                address <<= 8;
                mask <<= 8;
                if (pattern[i] == -1) continue;
                address |= pattern[i];
                mask |= 0xFF;
            }
            return new AddressMask(address, mask);
        }
    }
}

