/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.selenium.visualcomparison.utils;

import java.util.ArrayList;
import java.util.List;

public class BoundingBox {
    private int left;
    private int top;
    private int right;
    private int bottom;
    private int leftMargin;
    private int topMargin;
    private int rightMargin;
    private int bottomMargin;
    private static final int MARGIN = 25;

    public BoundingBox(int x, int y) {
        this(x, y, x, y);
    }

    public BoundingBox(int left, int top, int right, int bottom) {
        this.setLeft(left);
        this.setTop(top);
        this.setRight(right);
        this.setBottom(bottom);
    }

    private void setLeft(int left) {
        this.left = left;
        this.leftMargin = left - 25;
    }

    private void setRight(int right) {
        this.right = right;
        this.rightMargin = right + 25;
    }

    private void setTop(int top) {
        this.top = top;
        this.topMargin = top - 25;
    }

    private void setBottom(int bottom) {
        this.bottom = bottom;
        this.bottomMargin = bottom + 25;
    }

    public int getLeft() {
        return this.left;
    }

    public int getTop() {
        return this.top;
    }

    public int getRight() {
        return this.right;
    }

    public int getBottom() {
        return this.bottom;
    }

    public int getWidth() {
        return this.right - this.left + 1;
    }

    public int getHeight() {
        return this.bottom - this.top + 1;
    }

    public int getMarginLeft() {
        return Math.max(this.left - 25, 0);
    }

    public int getMarginTop() {
        return Math.max(this.top - 25, 0);
    }

    public int getMarginRight(int maxX) {
        return Math.min(this.right + 25, maxX);
    }

    public int getMarginBottom(int maxY) {
        return Math.min(this.bottom + 25, maxY);
    }

    public int getMarginWidth(int maxX) {
        return this.getMarginRight(maxX) - this.getMarginLeft() + 1;
    }

    public int getMarginHeight(int maxY) {
        return this.getMarginBottom(maxY) - this.getMarginTop() + 1;
    }

    public boolean contains(int x, int y) {
        return x >= this.left && x <= this.right && y >= this.top && y <= this.bottom;
    }

    public boolean isNear(int x, int y) {
        return x >= this.leftMargin && x <= this.rightMargin && y >= this.topMargin && y <= this.bottomMargin;
    }

    public boolean isNear(BoundingBox box) {
        return box.isNear(this.left, this.top) || box.isNear(this.right, this.top) || box.isNear(this.left, this.bottom) || box.isNear(this.right, this.bottom) || this.isNear(box.left, box.top) || this.isNear(box.right, box.top) || this.isNear(box.left, box.bottom) || this.isNear(box.right, box.bottom);
    }

    public void merge(int x, int y) {
        if (x < this.left) {
            this.setLeft(x);
        }
        if (x > this.right) {
            this.setRight(x);
        }
        if (y < this.top) {
            this.setTop(y);
        }
        if (y > this.bottom) {
            this.setBottom(y);
        }
    }

    public void merge(BoundingBox box) {
        this.merge(box.left, box.top);
        this.merge(box.right, box.bottom);
    }

    public static void mergeOverlappingBoxes(ArrayList<BoundingBox> boxes) {
        boolean mergePerformedThisLoop;
        do {
            mergePerformedThisLoop = false;
            for (int iCurrent = 0; iCurrent < boxes.size(); ++iCurrent) {
                BoundingBox current = boxes.get(iCurrent);
                int iOther = iCurrent + 1;
                while (iOther < boxes.size()) {
                    if (current.isNear(boxes.get(iOther))) {
                        current.merge(boxes.get(iOther));
                        boxes.remove(iOther);
                        mergePerformedThisLoop = true;
                        continue;
                    }
                    ++iOther;
                }
            }
        } while (mergePerformedThisLoop);
    }

    public static void deleteSingleLineBoxes(List<BoundingBox> boxes) {
        int i = 0;
        while (i < boxes.size()) {
            BoundingBox box = boxes.get(i);
            if (box.getWidth() == 1 || box.getHeight() == 1) {
                boxes.remove(i);
                continue;
            }
            ++i;
        }
    }
}

