/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.selenium.pageobjects;

import com.atlassian.selenium.SeleniumClient;

public class PageElement {
    protected final String locator;
    protected final SeleniumClient client;

    public PageElement(String locator, SeleniumClient client) {
        this.locator = locator;
        this.client = client;
    }

    public boolean isPresent() {
        return this.client.isElementPresent(this.locator);
    }

    public void click() {
        this.client.click(this.locator);
    }

    public String getLocator() {
        return this.locator;
    }

    public String toString() {
        return this.locator;
    }

    public String getText() {
        return this.client.getText(this.locator);
    }

    public int getPositionTop() {
        return this.client.getElementPositionTop(this.locator).intValue();
    }

    public int getPositionLeft() {
        return this.client.getElementPositionLeft(this.locator).intValue();
    }

    public int getWidth() {
        return this.client.getElementWidth(this.locator).intValue();
    }

    public int getHeight() {
        return this.client.getElementHeight(this.locator).intValue();
    }

    public void contextMenu(PageElement element) {
        this.client.contextMenu(element.getLocator());
    }

    public void doubleClick() {
        this.client.doubleClick(this.getLocator());
    }

    public void dragAndDrop(String movementsString) {
        this.client.dragAndDrop(this.getLocator(), movementsString);
    }

    public void dragAndDropToObject(PageElement dest) {
        this.client.dragAndDropToObject(this.getLocator(), dest.getLocator());
    }

    public void focus() {
        this.client.focus(this.getLocator());
    }

    public void getCursorPosition() {
        this.client.getCursorPosition(this.getLocator());
    }

    public Number getIndex() {
        return this.client.getElementIndex(this.getLocator());
    }

    public void highlight() {
        this.client.highlight(this.getLocator());
    }

    public void mouseDown() {
        this.client.mouseDown(this.getLocator());
    }

    public void mouseDownRight() {
        this.client.mouseDownRight(this.getLocator());
    }

    public void mouseMove() {
        this.client.mouseDown(this.getLocator());
    }

    public void mouseOut() {
        this.client.mouseOut(this.getLocator());
    }

    public void mouseOver() {
        this.client.mouseOver(this.getLocator());
    }

    public void mouseUp() {
        this.client.mouseUp(this.getLocator());
    }

    public void mouseUpRight() {
        this.client.mouseUpRight(this.getLocator());
    }

    public boolean isVisible() {
        return this.client.isElementPresent(this.getLocator()) && this.client.isVisible(this.getLocator());
    }

    public boolean isEditable() {
        return this.client.isEditable(this.getLocator());
    }

    public void keyDown(String keyCode) {
        this.client.keyDown(this.getLocator(), keyCode);
    }

    public void keyPress(String keyCode) {
        this.client.keyPress(this.getLocator(), keyCode);
    }

    public void keyUp(String keyCode) {
        this.client.keyUp(this.getLocator(), keyCode);
    }

    public void type(String value) {
        this.client.type(this.getLocator(), value);
    }

    public void typeKeys(String value) {
        this.client.typeKeys(this.getLocator(), value);
    }

    public void typeWithFullKeyEvents(String value) {
        this.client.typeWithFullKeyEvents(this.getLocator(), value);
    }
}

