/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.selenium;

import com.atlassian.selenium.MultiBrowserSeleniumClientInvocationHandler;
import com.atlassian.selenium.SeleniumClient;
import com.atlassian.selenium.SeleniumConfiguration;
import com.atlassian.selenium.SingleBrowserSeleniumClient;
import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import org.apache.log4j.Logger;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.SeleniumServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeleniumStarter {
    private static final Logger log = Logger.getLogger(SeleniumStarter.class);
    private static SeleniumStarter instance = new SeleniumStarter();
    private SeleniumClient client;
    private SeleniumServer server;
    private String userAgent;
    private boolean manual = true;

    private SeleniumStarter() {
    }

    public static SeleniumStarter getInstance() {
        return instance;
    }

    public synchronized SeleniumClient getSeleniumClient(SeleniumConfiguration config) {
        if (this.client == null) {
            this.client = new SingleBrowserSeleniumClient(config);
        }
        return this.client;
    }

    public SeleniumClient getSeleniumClient(List<SeleniumConfiguration> configs) {
        return this.getSeleniumClient(configs, false);
    }

    public synchronized SeleniumClient getSeleniumClient(List<SeleniumConfiguration> configs, boolean parallel) {
        if (this.client == null) {
            MultiBrowserSeleniumClientInvocationHandler ih = new MultiBrowserSeleniumClientInvocationHandler(configs, 10000000L, true, parallel);
            this.client = (SeleniumClient)Proxy.newProxyInstance(SeleniumClient.class.getClassLoader(), new Class[]{SeleniumClient.class}, (InvocationHandler)ih);
        }
        return this.client;
    }

    public synchronized SeleniumServer getSeleniumServer(SeleniumConfiguration config) {
        if (this.server == null) {
            try {
                RemoteControlConfiguration rcConfig = new RemoteControlConfiguration();
                rcConfig.setPort(config.getServerPort());
                rcConfig.setDebugMode(true);
                rcConfig.setSingleWindow(config.getSingleWindowMode());
                if (config.getFirefoxProfileTemplate() != null) {
                    rcConfig.setFirefoxProfileTemplate(new File(config.getFirefoxProfileTemplate()));
                }
                this.server = new SeleniumServer(rcConfig);
            }
            catch (Exception e) {
                log.error((Object)"Error creating SeleniumServer!", (Throwable)e);
            }
        }
        return this.server;
    }

    private void startServer(SeleniumConfiguration config) {
        try {
            if (config.getStartSeleniumServer()) {
                log.info((Object)"Starting Selenium Server");
                this.getSeleniumServer(config).start();
                log.info((Object)"Selenium Server Started");
            } else {
                log.info((Object)"Not starting Selenium Server");
            }
        }
        catch (Exception e) {
            log.error((Object)"Error starting SeleniumServer!", (Throwable)e);
        }
    }

    public void start(SeleniumConfiguration config) {
        log.info((Object)"Starting Selenium");
        this.startServer(config);
        log.info((Object)"Starting Selenium Client");
        this.getSeleniumClient(config).start();
        log.info((Object)"Selenium Client Started");
        log.info((Object)"Selenium startup complete");
    }

    public void start(List<SeleniumConfiguration> configs) {
        log.info((Object)"Starting Selenium");
        this.startServer(configs.get(0));
        log.info((Object)"Starting Selenium Client");
        this.getSeleniumClient(configs).start();
        log.info((Object)"Selenium Client Started");
        log.info((Object)"Selenium startup complete");
    }

    public void stop() {
        this.client.close();
        this.client.stop();
        if (this.server != null) {
            this.server.stop();
            this.server = null;
        }
    }

    public boolean isManual() {
        return this.manual;
    }

    public void setManual(boolean manual) {
        this.manual = manual;
    }
}

