/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pageobjects.elements.query;

import com.atlassian.pageobjects.elements.query.AbstractTimedQuery;
import com.atlassian.pageobjects.elements.query.ExpirationHandler;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.google.common.base.Supplier;
import java.util.Objects;

public final class Queries {
    private Queries() {
        throw new AssertionError((Object)"Don't instantiate me");
    }

    public static <T> TimedQuery<T> forSupplier(Timeouts timeouts, Supplier<T> supplier) {
        return Queries.forSupplier(timeouts, supplier, TimeoutType.DEFAULT);
    }

    public static <T> TimedQuery<T> forSupplier(Timeouts timeouts, final Supplier<T> supplier, TimeoutType timeoutType) {
        Objects.requireNonNull(timeouts, "timeouts");
        Objects.requireNonNull(timeoutType, "timeoutType");
        Objects.requireNonNull(supplier, "supplier");
        return new AbstractTimedQuery<T>(timeouts.timeoutFor(timeoutType), timeouts.timeoutFor(TimeoutType.EVALUATION_INTERVAL), ExpirationHandler.RETURN_CURRENT){

            @Override
            protected T currentValue() {
                return supplier.get();
            }

            @Override
            protected boolean shouldReturn(T currentEval) {
                return true;
            }
        };
    }
}

