/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pageobjects.elements.query.webdriver;

import com.atlassian.pageobjects.elements.query.AbstractTimedQuery;
import com.atlassian.pageobjects.elements.query.ExpirationHandler;
import com.google.common.base.Supplier;
import java.time.Clock;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class GenericWebDriverTimedQuery<T>
extends AbstractTimedQuery<T> {
    protected final Supplier<T> valueSupplier;
    private boolean invalidValue;

    public GenericWebDriverTimedQuery(Supplier<T> supplier, Clock clock, long defTimeout, long interval, ExpirationHandler eh) {
        super(clock, defTimeout, interval, eh);
        this.valueSupplier = Objects.requireNonNull(supplier);
    }

    public GenericWebDriverTimedQuery(Supplier<T> supplier, long defTimeout, long interval, ExpirationHandler eh) {
        this(supplier, Clock.systemUTC(), defTimeout, interval, eh);
    }

    public GenericWebDriverTimedQuery(Supplier<T> supplier, long defTimeout, long interval) {
        this(supplier, Clock.systemUTC(), defTimeout, interval, ExpirationHandler.RETURN_CURRENT);
    }

    public GenericWebDriverTimedQuery(Supplier<T> supplier, long defTimeout) {
        this(supplier, Clock.systemUTC(), defTimeout, 100L, ExpirationHandler.RETURN_CURRENT);
    }

    public GenericWebDriverTimedQuery(GenericWebDriverTimedQuery<T> origin, long timeout) {
        this(origin.valueSupplier, origin.clock(), timeout, origin.interval(), origin.expirationHandler());
    }

    @Override
    protected final boolean shouldReturn(T currentEval) {
        return !this.invalidValue;
    }

    @Override
    protected final T currentValue() {
        this.invalidValue = false;
        try {
            return (T)this.valueSupplier.get();
        }
        catch (InvalidValue e) {
            this.invalidValue = true;
            Object value = e.value;
            return (T)value;
        }
    }

    public static final class InvalidValue
    extends RuntimeException {
        private static final long serialVersionUID = -4972134972343443297L;
        private final Object value;

        public InvalidValue(Object value) {
            this.value = value;
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

