/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pageobjects.internal.elements.search;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.WebDriverElement;
import com.atlassian.pageobjects.elements.WebDriverLocatable;
import com.atlassian.pageobjects.elements.WebDriverLocators;
import com.atlassian.pageobjects.elements.search.AnyQuery;
import com.atlassian.pageobjects.elements.search.PageElementQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.pageobjects.internal.elements.search.AbstractSearchQuery;
import com.atlassian.pageobjects.internal.elements.search.DefaultAnyQuery;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.commons.lang.mutable.MutableInt;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class WebDriverElementQuery<E extends PageElement>
extends AbstractSearchQuery<E, PageElementQuery<E>>
implements PageElementQuery<E> {
    @Inject
    protected WebDriver webDriver;
    protected final Class<E> pageElementClass;
    protected final TimeoutType timeoutType;

    public WebDriverElementQuery(@Nonnull Supplier<Iterable<E>> querySupplier, @Nonnull Class<E> pageElementClass, @Nonnull TimeoutType timeoutType) {
        super(querySupplier);
        this.pageElementClass = (Class)Preconditions.checkNotNull(pageElementClass, (Object)"pageElementClass");
        this.timeoutType = (TimeoutType)((Object)Preconditions.checkNotNull((Object)((Object)timeoutType), (Object)"timeoutType"));
    }

    @Override
    @Nonnull
    public PageElementQuery<E> by(@Nonnull By by) {
        return this.by(by, (Predicate<PageElement>)Predicates.alwaysTrue());
    }

    @Override
    @Nonnull
    public PageElementQuery<E> by(@Nonnull By by, @Nonnull Predicate<? super PageElement> filter) {
        return this.newInstance((Supplier)this.flatMapSupplier(this.searchAndFilter(by, filter)));
    }

    @Override
    @Nonnull
    public PageElementQuery<E> withTimeout(@Nonnull TimeoutType timeoutType) {
        return super.rebind();
    }

    @Override
    @Nonnull
    public <PE extends E> PageElementQuery<PE> as(@Nonnull Class<PE> pageElementClass) {
        return super.rebind();
    }

    @Override
    @Nonnull
    protected <F> AnyQuery<F> newAnyQueryInstance(@Nonnull Supplier<Iterable<F>> supplier) {
        return (AnyQuery)this.pageBinder.bind(DefaultAnyQuery.class, new Object[]{supplier});
    }

    @Override
    @Nonnull
    protected PageElementQuery<E> newInstance(@Nonnull Supplier<Iterable<E>> supplier) {
        return this.newInstance(supplier, this.pageElementClass, this.timeoutType);
    }

    private <PE extends E> WebDriverElementQuery<PE> newInstance(Supplier<Iterable<E>> supplier, Class<PE> pageElementClass, TimeoutType timeoutType) {
        return (WebDriverElementQuery)this.pageBinder.bind(WebDriverElementQuery.class, new Object[]{Preconditions.checkNotNull(supplier, (Object)"supplier"), Preconditions.checkNotNull(pageElementClass, (Object)"pageElementClass"), Preconditions.checkNotNull((Object)((Object)timeoutType), (Object)"timeoutType")});
    }

    private static Function<WebElement, WebDriverLocatable> toListLocatable(final By locator, final MutableInt index, final WebDriverLocatable parent) {
        return new Function<WebElement, WebDriverLocatable>(){

            public WebDriverLocatable apply(WebElement element) {
                WebDriverLocatable result = WebDriverLocators.list(element, locator, index.intValue(), parent);
                index.increment();
                return result;
            }
        };
    }

    private PageElementQuery<E> rebind() {
        return this.newInstance((Supplier)this.mapSupplier(this.rebindFunction()));
    }

    private Function<? super E, E> rebindFunction() {
        return Functions.compose(WebDriverElement.bind(this.pageBinder, this.pageElementClass, this.timeoutType), WebDriverElement.TO_LOCATABLE);
    }

    private Function<? super E, Iterable<E>> searchAndFilter(final By by, final Predicate<? super PageElement> filter) {
        return new Function<E, Iterable<E>>(){

            @Nullable
            public Iterable<E> apply(E element) {
                try {
                    WebDriverLocatable root = WebDriverElement.toLocatable(element);
                    SearchContext searchContext = root.waitUntilLocated(WebDriverElementQuery.this.webDriver, WebDriverLocatable.LocateTimeout.zero());
                    return FluentIterable.from((Iterable)searchContext.findElements(by)).transform(WebDriverElementQuery.toListLocatable(by, new MutableInt(), root)).transform(WebDriverElement.bind(WebDriverElementQuery.this.pageBinder, WebDriverElementQuery.this.pageElementClass, WebDriverElementQuery.this.timeoutType)).filter(filter).toList();
                }
                catch (NoSuchElementException e) {
                    return Collections.emptyList();
                }
                catch (StaleElementReferenceException e) {
                    return Collections.emptyList();
                }
            }
        };
    }
}

