/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pageobjects.elements;

import com.atlassian.annotations.Internal;
import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementJavascript;
import com.atlassian.pageobjects.elements.TimedElement;
import com.atlassian.pageobjects.elements.WebDriverElementJavascript;
import com.atlassian.pageobjects.elements.WebDriverElementMappings;
import com.atlassian.pageobjects.elements.WebDriverLocatable;
import com.atlassian.pageobjects.elements.WebDriverLocators;
import com.atlassian.pageobjects.elements.WebDriverTimedElement;
import com.atlassian.pageobjects.elements.search.DefaultQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.pageobjects.internal.elements.search.DefaultWebDriverQuery;
import com.atlassian.webdriver.Elements;
import com.atlassian.webdriver.utils.Check;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

@Internal
public class WebDriverElement
implements PageElement {
    public static Function<PageElement, WebDriverLocatable> TO_LOCATABLE = new Function<PageElement, WebDriverLocatable>(){

        public WebDriverLocatable apply(PageElement element) {
            return WebDriverElement.toLocatable(element);
        }
    };
    @Inject
    protected WebDriver driver;
    @Inject
    protected PageBinder pageBinder;
    @Inject
    protected Timeouts timeouts;
    protected final WebDriverLocatable locatable;
    protected final TimeoutType defaultTimeout;

    @Nonnull
    public static <P extends PageElement> Function<WebDriverLocatable, P> bind(final @Nonnull PageBinder pageBinder, final @Nonnull Class<P> elementType, final @Nonnull TimeoutType timeoutType) {
        Preconditions.checkNotNull((Object)pageBinder, (Object)"pageBinder");
        Preconditions.checkNotNull(elementType, (Object)"elementType");
        Preconditions.checkNotNull((Object)((Object)timeoutType), (Object)"timeoutType");
        return new Function<WebDriverLocatable, P>(){

            public P apply(WebDriverLocatable locatable) {
                return (PageElement)pageBinder.bind(WebDriverElementMappings.findMapping(elementType), new Object[]{locatable, timeoutType});
            }
        };
    }

    @Nonnull
    public static WebDriverLocatable toLocatable(@Nonnull PageElement pageElement) {
        return WebDriverElement.cast((PageElement)pageElement).locatable;
    }

    static WebElement getWebElement(PageElement element) {
        return WebDriverElement.cast(element).asWebElement();
    }

    private static WebDriverElement cast(PageElement element) {
        if (!WebDriverElement.class.isInstance(element)) {
            throw new IllegalStateException("Unknown implementation of PageElement, cannot use to retrieve WebElement");
        }
        return (WebDriverElement)WebDriverElement.class.cast(element);
    }

    public WebDriverElement(By locator) {
        this(locator, TimeoutType.DEFAULT);
    }

    public WebDriverElement(By locator, TimeoutType timeoutType) {
        this(locator, WebDriverLocators.root(), timeoutType);
    }

    public WebDriverElement(By locator, WebDriverLocatable parent) {
        this(locator, parent, TimeoutType.DEFAULT);
    }

    public WebDriverElement(By locator, WebDriverLocatable parent, TimeoutType timeoutType) {
        this(WebDriverLocators.nested(locator, parent), timeoutType);
    }

    public WebDriverElement(WebDriverLocatable locatable, TimeoutType timeoutType) {
        this.locatable = (WebDriverLocatable)Preconditions.checkNotNull((Object)locatable, (Object)"locatable");
        this.defaultTimeout = (TimeoutType)((Object)Preconditions.checkNotNull((Object)((Object)timeoutType), (Object)"timeoutType"));
    }

    protected long timeout() {
        return this.timeouts.timeoutFor(this.defaultTimeout);
    }

    protected WebDriverLocatable.LocateTimeout createTimout() {
        return new WebDriverLocatable.LocateTimeout.Builder().timeout(this.timeout()).pollInterval(this.timeouts.timeoutFor(TimeoutType.EVALUATION_INTERVAL)).build();
    }

    @Override
    public boolean isPresent() {
        return this.locatable.isPresent(this.driver, this.createTimout());
    }

    @Override
    public boolean isVisible() {
        WebElement element = this.waitForWebElement();
        return element.isDisplayed();
    }

    @Override
    public boolean isEnabled() {
        return this.waitForWebElement().isEnabled();
    }

    @Override
    public boolean isSelected() {
        return this.waitForWebElement().isSelected();
    }

    @Override
    @Nullable
    public String getId() {
        return this.getAttribute("id");
    }

    @Override
    @Nonnull
    public Set<String> getCssClasses() {
        return Elements.getCssClasses((String)this.getAttribute("class"));
    }

    @Override
    public boolean hasClass(@Nonnull String className) {
        Preconditions.checkNotNull((Object)className, (Object)"className");
        return Check.hasClass((String)className, (WebElement)this.waitForWebElement());
    }

    @Override
    public String getAttribute(@Nonnull String name) {
        return this.waitForWebElement().getAttribute(name);
    }

    @Override
    public boolean hasAttribute(@Nonnull String name, String value) {
        return value.equals(this.getAttribute(name));
    }

    @Override
    public String getText() {
        return this.waitForWebElement().getText();
    }

    @Override
    @Nonnull
    public String getTagName() {
        return this.waitForWebElement().getTagName();
    }

    @Override
    public String getValue() {
        return this.waitForWebElement().getAttribute("value");
    }

    @Override
    @Nonnull
    public Point getLocation() {
        return this.waitForWebElement().getLocation();
    }

    @Override
    @Nonnull
    public Dimension getSize() {
        return this.waitForWebElement().getSize();
    }

    @Override
    @Nonnull
    public PageElement click() {
        this.waitForWebElement().click();
        return this;
    }

    @Override
    @Nonnull
    public PageElement type(CharSequence ... keysToSend) {
        this.waitForWebElement().sendKeys(keysToSend);
        return this;
    }

    @Override
    @Nonnull
    public PageElement select() {
        WebElement el = this.waitForWebElement();
        if (!el.isSelected()) {
            el.click();
        }
        return this;
    }

    @Override
    @Nonnull
    public PageElement toggle() {
        WebElement el = this.waitForWebElement();
        el.click();
        return this;
    }

    @Override
    @Nonnull
    public PageElement clear() {
        this.waitForWebElement().clear();
        return this;
    }

    @Override
    @Nonnull
    public TimedElement timed() {
        return (TimedElement)this.pageBinder.bind(WebDriverTimedElement.class, new Object[]{this.locatable, this.defaultTimeout});
    }

    @Override
    @Nonnull
    public PageElementJavascript javascript() {
        return new WebDriverElementJavascript(this);
    }

    @Override
    @Nonnull
    public PageElement find(@Nonnull By locator) {
        return (PageElement)this.pageBinder.bind(WebDriverElement.class, new Object[]{locator, this.locatable});
    }

    @Override
    @Nonnull
    public PageElement find(@Nonnull By locator, @Nonnull TimeoutType timeoutType) {
        return (PageElement)this.pageBinder.bind(WebDriverElement.class, new Object[]{locator, this.locatable, timeoutType});
    }

    @Override
    @Nonnull
    public <T extends PageElement> T find(@Nonnull By locator, @Nonnull Class<T> elementClass) {
        return (T)((PageElement)this.pageBinder.bind(WebDriverElementMappings.findMapping(elementClass), new Object[]{locator, this.locatable}));
    }

    @Override
    @Nonnull
    public <T extends PageElement> T find(@Nonnull By locator, @Nonnull Class<T> elementClass, @Nonnull TimeoutType timeoutType) {
        return (T)((PageElement)this.pageBinder.bind(WebDriverElementMappings.findMapping(elementClass), new Object[]{locator, this.locatable, timeoutType}));
    }

    @Override
    @Nonnull
    public List<PageElement> findAll(@Nonnull By locator) {
        return this.findAll(locator, this.defaultTimeout);
    }

    @Override
    @Nonnull
    public List<PageElement> findAll(@Nonnull By locator, @Nonnull TimeoutType timeoutType) {
        return this.findAll(locator, PageElement.class, timeoutType);
    }

    @Override
    @Nonnull
    public <T extends PageElement> List<T> findAll(@Nonnull By locator, @Nonnull Class<T> elementClass) {
        return this.findAll(locator, elementClass, this.defaultTimeout);
    }

    @Override
    @Nonnull
    public <T extends PageElement> List<T> findAll(@Nonnull By locator, @Nonnull Class<T> elementClass, @Nonnull TimeoutType timeoutType) {
        LinkedList elements = Lists.newLinkedList();
        List webElements = this.waitForWebElement().findElements(locator);
        for (int i = 0; i < webElements.size(); ++i) {
            elements.add(this.pageBinder.bind(WebDriverElementMappings.findMapping(elementClass), new Object[]{WebDriverLocators.list((WebElement)webElements.get(i), locator, i, this.locatable), timeoutType}));
        }
        return elements;
    }

    @Override
    @Nonnull
    public PageElement withTimeout(@Nonnull TimeoutType timeoutType) {
        if (this.defaultTimeout == timeoutType) {
            return this;
        }
        return (PageElement)this.pageBinder.bind(WebDriverElement.class, new Object[]{this.locatable, Preconditions.checkNotNull((Object)((Object)timeoutType))});
    }

    @Override
    @Nonnull
    public DefaultQuery search() {
        return (DefaultQuery)this.pageBinder.bind(DefaultWebDriverQuery.class, new Object[]{this});
    }

    @Nonnull
    public WebElement asWebElement() {
        return this.waitForWebElement();
    }

    @Nonnull
    public TimeoutType getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public String toString() {
        return "WebDriverElement[locatable=" + this.locatable + ",defaultTimeout=" + (Object)((Object)this.defaultTimeout) + "]";
    }

    protected WebElement waitForWebElement() {
        return this.waitForWebElement(this.createTimout());
    }

    protected WebElement waitForWebElement(WebDriverLocatable.LocateTimeout timeout) {
        return (WebElement)this.locatable.waitUntilLocated(this.driver, timeout);
    }
}

