/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pageobjects.elements.query.webdriver;

import com.atlassian.pageobjects.elements.query.webdriver.GenericWebDriverTimedQuery;
import com.atlassian.pageobjects.elements.util.StringConcat;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class WebElementBasedTimedQuery<T>
extends GenericWebDriverTimedQuery<T> {
    private final By by;

    public WebElementBasedTimedQuery(WebDriver driver, By by, Function<WebElement, T> valueProvider, long timeout) {
        super(new WebElementSupplier<T>((SearchContext)driver, by, valueProvider), timeout);
        this.by = by;
    }

    public WebElementBasedTimedQuery(SearchContext searchContext, By by, Function<WebElement, T> valueProvider, long timeout, long interval) {
        super(new WebElementSupplier<T>(searchContext, by, valueProvider), timeout, interval);
        this.by = by;
    }

    public WebElementBasedTimedQuery(SearchContext searchContext, By by, Function<WebElement, T> valueProvider, long timeout, long interval, T invalidValue) {
        super(new WebElementSupplier<T>(searchContext, by, valueProvider, invalidValue), timeout, interval);
        this.by = by;
    }

    public WebElementBasedTimedQuery(WebElementBasedTimedQuery<T> origin, long timeout) {
        super(origin.webElementSupplier(), timeout, origin.interval);
        this.by = null;
    }

    WebElementSupplier<T> webElementSupplier() {
        return (WebElementSupplier)this.valueSupplier;
    }

    @Override
    public String toString() {
        return StringConcat.asString(super.toString(), "[locator=", this.by, "]");
    }

    private static class WebElementSupplier<S>
    implements Supplier<S> {
        private final SearchContext searchContext;
        private final By by;
        private final Function<WebElement, S> valueProvider;
        private final S invalidValue;

        public WebElementSupplier(SearchContext searchContext, By by, Function<WebElement, S> valueProvider, S invalid) {
            this.valueProvider = valueProvider;
            this.searchContext = (SearchContext)Preconditions.checkNotNull((Object)searchContext);
            this.by = (By)Preconditions.checkNotNull((Object)by);
            this.invalidValue = invalid;
        }

        public WebElementSupplier(SearchContext searchContext, By by, Function<WebElement, S> valueProvider) {
            this(searchContext, by, valueProvider, null);
        }

        public S get() {
            try {
                return (S)this.valueProvider.apply((Object)this.searchContext.findElement(this.by));
            }
            catch (NoSuchElementException e) {
                throw new GenericWebDriverTimedQuery.InvalidValue(this.invalidValue);
            }
        }
    }
}

