/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pageobjects.elements.query.webdriver;

import com.atlassian.pageobjects.elements.WebDriverLocatable;
import com.atlassian.pageobjects.elements.query.webdriver.GenericWebDriverTimedQuery;
import com.atlassian.pageobjects.elements.util.StringConcat;
import com.atlassian.webdriver.AtlassianWebDriver;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class WebDriverLocatableBasedTimedQuery<T>
extends GenericWebDriverTimedQuery<T> {
    private final WebDriverLocatable locatable;

    public WebDriverLocatableBasedTimedQuery(WebDriverLocatable locatable, AtlassianWebDriver driver, Function<WebElement, T> valueProvider, long timeout) {
        super(new LocatableBasedSupplier<T>(driver, locatable, valueProvider), timeout);
        this.locatable = locatable;
    }

    public WebDriverLocatableBasedTimedQuery(WebDriverLocatable locatable, AtlassianWebDriver driver, Function<WebElement, T> valueProvider, long timeout, long interval) {
        super(new LocatableBasedSupplier<T>(driver, locatable, valueProvider), timeout, interval);
        this.locatable = locatable;
    }

    public WebDriverLocatableBasedTimedQuery(WebDriverLocatable locatable, AtlassianWebDriver driver, Function<WebElement, T> valueProvider, long timeout, long interval, T invalidValue) {
        super(new LocatableBasedSupplier<T>(driver, locatable, valueProvider, invalidValue), timeout, interval);
        this.locatable = locatable;
    }

    public WebDriverLocatableBasedTimedQuery(WebDriverLocatableBasedTimedQuery<T> origin, long timeout) {
        super(origin.webElementSupplier(), timeout, origin.interval);
        this.locatable = origin.locatable;
    }

    LocatableBasedSupplier<T> webElementSupplier() {
        return (LocatableBasedSupplier)this.valueSupplier;
    }

    Function<WebElement, T> valueProvider() {
        return ((LocatableBasedSupplier)this.webElementSupplier()).valueProvider;
    }

    @Override
    public String toString() {
        return StringConcat.asString(super.toString(), "[locatable=", this.locatable, ",valueProvider=", this.valueProvider(), "]");
    }

    private static class LocatableBasedSupplier<S>
    implements Supplier<S> {
        private final AtlassianWebDriver webDriver;
        private final WebDriverLocatable locatable;
        private final Function<WebElement, S> valueProvider;
        private final S invalidValue;

        public LocatableBasedSupplier(AtlassianWebDriver webDriver, WebDriverLocatable locatable, Function<WebElement, S> valueProvider, S invalid) {
            this.valueProvider = valueProvider;
            this.webDriver = webDriver;
            this.locatable = (WebDriverLocatable)Preconditions.checkNotNull((Object)locatable);
            this.invalidValue = invalid;
        }

        public LocatableBasedSupplier(AtlassianWebDriver webDriver, WebDriverLocatable locatable, Function<WebElement, S> valueProvider) {
            this(webDriver, locatable, valueProvider, null);
        }

        public S get() {
            try {
                return (S)this.valueProvider.apply((Object)((WebElement)this.locatable.waitUntilLocated((WebDriver)this.webDriver, 0)));
            }
            catch (StaleElementReferenceException e) {
                throw new GenericWebDriverTimedQuery.InvalidValue(this.invalidValue);
            }
            catch (NoSuchElementException e1) {
                throw new GenericWebDriverTimedQuery.InvalidValue(this.invalidValue);
            }
        }
    }
}

