/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pageobjects.elements;

import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementJavascript;
import com.atlassian.pageobjects.elements.TimedElement;
import com.atlassian.pageobjects.elements.WebDriverElementJavascript;
import com.atlassian.pageobjects.elements.WebDriverElementMappings;
import com.atlassian.pageobjects.elements.WebDriverLocatable;
import com.atlassian.pageobjects.elements.WebDriverLocators;
import com.atlassian.pageobjects.elements.WebDriverTimedElement;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.AtlassianWebDriver;
import com.atlassian.webdriver.utils.Check;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class WebDriverElement
implements PageElement {
    @Inject
    protected AtlassianWebDriver driver;
    @Inject
    protected PageBinder pageBinder;
    @Inject
    protected Timeouts timeouts;
    protected final WebDriverLocatable locatable;
    protected final TimeoutType defaultTimeout;

    static WebElement getWebElement(PageElement element) {
        if (!WebDriverElement.class.isInstance(element)) {
            throw new IllegalStateException("Unknown implementation of PageElement, cannot use to retrieve WebElement");
        }
        return ((WebDriverElement)WebDriverElement.class.cast(element)).asWebElement();
    }

    public WebDriverElement(By locator) {
        this(locator, TimeoutType.DEFAULT);
    }

    public WebDriverElement(By locator, TimeoutType timeoutType) {
        this(locator, WebDriverLocators.root(), timeoutType);
    }

    public WebDriverElement(By locator, WebDriverLocatable parent) {
        this(locator, parent, TimeoutType.DEFAULT);
    }

    public WebDriverElement(By locator, WebDriverLocatable parent, TimeoutType timeoutType) {
        this(WebDriverLocators.nested(locator, parent), timeoutType);
    }

    public WebDriverElement(WebDriverLocatable locatable, TimeoutType timeoutType) {
        this.locatable = (WebDriverLocatable)Preconditions.checkNotNull((Object)locatable, (Object)"locatable");
        this.defaultTimeout = (TimeoutType)((Object)Preconditions.checkNotNull((Object)((Object)timeoutType), (Object)"timeoutType"));
    }

    protected long timeout() {
        return this.timeouts.timeoutFor(this.defaultTimeout);
    }

    protected WebDriverLocatable.LocateTimeout createTimout() {
        return new WebDriverLocatable.LocateTimeout.Builder().timeout(this.timeout()).pollInterval(this.timeouts.timeoutFor(TimeoutType.EVALUATION_INTERVAL)).build();
    }

    protected WebElement waitForWebElement() {
        return (WebElement)this.locatable.waitUntilLocated((WebDriver)this.driver, this.createTimout());
    }

    @Override
    public boolean isPresent() {
        return this.locatable.isPresent((WebDriver)this.driver, this.createTimout());
    }

    @Override
    public boolean isVisible() {
        WebElement element = this.waitForWebElement();
        return element.isDisplayed();
    }

    @Override
    public boolean isEnabled() {
        return this.waitForWebElement().isEnabled();
    }

    @Override
    public boolean isSelected() {
        return this.waitForWebElement().isSelected();
    }

    @Override
    public boolean hasClass(String className) {
        return Check.hasClass((String)className, (WebElement)this.waitForWebElement());
    }

    @Override
    public String getAttribute(String name) {
        return this.waitForWebElement().getAttribute(name);
    }

    @Override
    public boolean hasAttribute(String name, String value) {
        return value.equals(this.getAttribute(name));
    }

    @Override
    public String getText() {
        return this.waitForWebElement().getText();
    }

    @Override
    public String getTagName() {
        return this.waitForWebElement().getTagName();
    }

    @Override
    public String getValue() {
        return this.waitForWebElement().getAttribute("value");
    }

    @Override
    public Point getLocation() {
        return this.waitForWebElement().getLocation();
    }

    @Override
    public Dimension getSize() {
        return this.waitForWebElement().getSize();
    }

    @Override
    public PageElement click() {
        this.waitForWebElement().click();
        return this;
    }

    @Override
    public PageElement type(CharSequence ... keysToSend) {
        this.waitForWebElement().sendKeys(keysToSend);
        return this;
    }

    @Override
    public PageElement select() {
        WebElement el = this.waitForWebElement();
        if (!el.isSelected()) {
            el.click();
        }
        return this;
    }

    @Override
    public PageElement toggle() {
        WebElement el = this.waitForWebElement();
        el.click();
        return this;
    }

    @Override
    public PageElement clear() {
        this.waitForWebElement().clear();
        return this;
    }

    @Override
    public TimedElement timed() {
        return (TimedElement)this.pageBinder.bind(WebDriverTimedElement.class, new Object[]{this.locatable, this.defaultTimeout});
    }

    @Override
    public PageElementJavascript javascript() {
        return new WebDriverElementJavascript(this);
    }

    @Override
    public PageElement find(By locator) {
        return (PageElement)this.pageBinder.bind(WebDriverElement.class, new Object[]{locator, this.locatable});
    }

    @Override
    public PageElement find(By locator, TimeoutType timeoutType) {
        return (PageElement)this.pageBinder.bind(WebDriverElement.class, new Object[]{locator, this.locatable, timeoutType});
    }

    @Override
    public <T extends PageElement> T find(By locator, Class<T> elementClass) {
        return (T)((PageElement)this.pageBinder.bind(WebDriverElementMappings.findMapping(elementClass), new Object[]{locator, this.locatable}));
    }

    @Override
    public <T extends PageElement> T find(By locator, Class<T> elementClass, TimeoutType timeoutType) {
        return (T)((PageElement)this.pageBinder.bind(WebDriverElementMappings.findMapping(elementClass), new Object[]{locator, this.locatable, timeoutType}));
    }

    @Override
    public List<PageElement> findAll(By locator) {
        return this.findAll(locator, this.defaultTimeout);
    }

    @Override
    public List<PageElement> findAll(By locator, TimeoutType timeoutType) {
        return this.findAll(locator, PageElement.class, timeoutType);
    }

    @Override
    public <T extends PageElement> List<T> findAll(By locator, Class<T> elementClass) {
        return this.findAll(locator, elementClass, this.defaultTimeout);
    }

    @Override
    public <T extends PageElement> List<T> findAll(By locator, Class<T> elementClass, TimeoutType timeoutType) {
        LinkedList elements = Lists.newLinkedList();
        List webElements = this.waitForWebElement().findElements(locator);
        for (int i = 0; i < webElements.size(); ++i) {
            elements.add(this.pageBinder.bind(WebDriverElementMappings.findMapping(elementClass), new Object[]{WebDriverLocators.list((WebElement)webElements.get(i), locator, i, this.locatable), timeoutType}));
        }
        return elements;
    }

    public WebElement asWebElement() {
        return this.waitForWebElement();
    }

    @Override
    public PageElement withTimeout(TimeoutType timeoutType) {
        if (this.defaultTimeout == timeoutType) {
            return this;
        }
        return (PageElement)this.pageBinder.bind(WebDriverElement.class, new Object[]{this.locatable, Preconditions.checkNotNull((Object)((Object)timeoutType))});
    }

    public String toString() {
        return "WebDriverElement[locatable=" + this.locatable + ",defaultTimeout=" + (Object)((Object)this.defaultTimeout) + "]";
    }
}

