/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pageobjects.elements;

import com.atlassian.pageobjects.binder.PostInjectionProcessor;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.PageElementIterableImpl;
import com.atlassian.pageobjects.util.InjectUtils;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.openqa.selenium.By;

public class ElementByPostInjectionProcessor
implements PostInjectionProcessor {
    @Inject
    PageElementFinder finder;

    public <T> T process(T pageObject) {
        this.injectElements(pageObject);
        return pageObject;
    }

    private void injectElements(final Object instance) {
        int previousChildSize;
        final HashMap populatedFields = Maps.newHashMap();
        final ArrayList childFields = Lists.newArrayList();
        InjectUtils.forEachFieldWithAnnotation((Object)instance, ElementBy.class, (InjectUtils.FieldVisitor)new InjectUtils.FieldVisitor<ElementBy>(){

            public void visit(Field field, ElementBy annotation) {
                if (StringUtils.isNotEmpty((String)annotation.within())) {
                    childFields.add(field);
                } else {
                    Object result = ElementByPostInjectionProcessor.this.createAndInject(field, annotation, instance, ElementByPostInjectionProcessor.this.getFinder(instance));
                    populatedFields.put(field.getName(), result);
                }
            }
        });
        do {
            previousChildSize = childFields.size();
            Iterator childFieldIterator = childFields.iterator();
            while (childFieldIterator.hasNext()) {
                Field childField = (Field)childFieldIterator.next();
                ElementBy elementBy = childField.getAnnotation(ElementBy.class);
                Object parent = populatedFields.get(elementBy.within());
                if (parent != null && parent instanceof PageElementFinder) {
                    Object result = this.createAndInject(childField, elementBy, instance, (PageElementFinder)parent);
                    populatedFields.put(childField.getName(), result);
                    childFieldIterator.remove();
                    continue;
                }
                if (parent == null) continue;
                throw new IllegalStateException("@ElementBy for field " + childField.getName() + " defines parent '" + elementBy.within() + "' whose value is of type '" + parent.getClass().getName() + "'. Parent " + "fields must be strictly instances of '" + PageElementFinder.class.getName() + "' (usually " + " that would be '" + PageElement.class.getName() + "')");
            }
        } while (!childFields.isEmpty() && childFields.size() < previousChildSize);
        if (!childFields.isEmpty()) {
            throw new IllegalStateException("Could not find parents for fields " + Lists.transform((List)childFields, (Function)FieldToName.INSTANCE) + " annotated with @ElementBy in <" + instance + ">. Please verify the problematic fields in the page object class");
        }
    }

    private PageElementFinder getFinder(Object instance) {
        if (instance instanceof PageElementFinder) {
            return (PageElementFinder)instance;
        }
        return this.finder;
    }

    private Object createAndInject(Field field, ElementBy annotation, Object instance, PageElementFinder elementFinder) {
        Object value = this.isIterable(field) ? this.createIterable(field, annotation, elementFinder) : this.createPageElement(field, annotation, elementFinder);
        try {
            field.setAccessible(true);
            field.set(instance, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return value;
    }

    private Iterable<? extends PageElement> createIterable(Field field, ElementBy elementBy, PageElementFinder elementFinder) {
        By by = this.getSelector(elementBy);
        Class<? extends PageElement> fieldType = this.getFieldType(field, elementBy);
        return new PageElementIterableImpl(elementFinder, fieldType, by, elementBy.timeoutType());
    }

    private PageElement createPageElement(Field field, ElementBy elementBy, PageElementFinder elementFinder) {
        By by = this.getSelector(elementBy);
        Class<? extends PageElement> fieldType = this.getFieldType(field, elementBy);
        return elementFinder.find(by, fieldType, elementBy.timeoutType());
    }

    private By getSelector(ElementBy elementBy) {
        By by;
        if (elementBy.className().length() > 0) {
            by = By.className((String)elementBy.className());
        } else if (elementBy.id().length() > 0) {
            by = By.id((String)elementBy.id());
        } else if (elementBy.linkText().length() > 0) {
            by = By.linkText((String)elementBy.linkText());
        } else if (elementBy.partialLinkText().length() > 0) {
            by = By.partialLinkText((String)elementBy.partialLinkText());
        } else if (elementBy.cssSelector().length() > 0) {
            by = By.cssSelector((String)elementBy.cssSelector());
        } else if (elementBy.name().length() > 0) {
            by = By.name((String)elementBy.name());
        } else if (elementBy.xpath().length() > 0) {
            by = By.xpath((String)elementBy.xpath());
        } else if (elementBy.tagName().length() > 0) {
            by = By.tagName((String)elementBy.tagName());
        } else {
            throw new IllegalArgumentException("No selector found");
        }
        return by;
    }

    private Class<? extends PageElement> getFieldType(Field field, ElementBy annotation) {
        Class<? extends PageElement> fieldType = field.getType();
        Class<? extends PageElement> annotatedType = annotation.pageElementClass();
        if (Iterable.class.isAssignableFrom(fieldType)) {
            return annotatedType;
        }
        if (annotatedType != PageElement.class) {
            Preconditions.checkArgument((boolean)fieldType.isAssignableFrom(annotatedType), (Object)("Field type " + annotatedType.getName() + " does not implement " + fieldType.getName()));
            return annotatedType;
        }
        Preconditions.checkArgument((boolean)PageElement.class.isAssignableFrom(fieldType), (Object)("Field type " + fieldType.getName() + " does not implement " + PageElement.class.getName()));
        return fieldType;
    }

    private boolean isIterable(Field field) {
        return Iterable.class.isAssignableFrom(field.getType());
    }

    private static enum FieldToName implements Function<Field, String>
    {
        INSTANCE;


        public String apply(Field from) {
            return from.getName();
        }
    }
}

