/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pageobjects.binder;

import com.atlassian.pageobjects.browser.Browser;
import com.atlassian.pageobjects.browser.BrowserAware;
import com.google.inject.AbstractModule;
import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Provider;
import java.util.Map;
import javax.inject.Inject;

public class BrowserModule
extends AbstractModule {
    protected void configure() {
        this.bind(BrowserAware.class).toProvider(BrowserAwareProvider.class);
        this.bind(Browser.class).toProvider(BrowserProvider.class);
    }

    public static class BrowserProvider
    extends AbstractBrowserAwareFinder
    implements Provider<Browser> {
        @Inject
        public BrowserProvider(Injector injector) {
            super(injector);
        }

        public Browser get() {
            return this.browserAware.getBrowser();
        }
    }

    public static class BrowserAwareProvider
    extends AbstractBrowserAwareFinder
    implements Provider<BrowserAware> {
        @Inject
        public BrowserAwareProvider(Injector injector) {
            super(injector);
        }

        public BrowserAware get() {
            return this.browserAware;
        }
    }

    protected static class AbstractBrowserAwareFinder {
        protected final BrowserAware browserAware;

        protected AbstractBrowserAwareFinder(Injector injector) {
            this.browserAware = this.find(injector);
        }

        private BrowserAware find(Injector injector) {
            for (Map.Entry entry : injector.getBindings().entrySet()) {
                if (!(((Binding)entry.getValue()).getProvider().get() instanceof BrowserAware)) continue;
                return (BrowserAware)((Binding)entry.getValue()).getProvider().get();
            }
            throw new IllegalStateException("BrowserAware not found in this injector");
        }
    }
}

