/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.security.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class SecureXmlParserFactory {
    private static InputStream EMPTY_INPUT_STREAM = new ByteArrayInputStream(new byte[0]);
    private static EntityResolver emptyEntityResolver = new EntityResolver(){

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return new InputSource(EMPTY_INPUT_STREAM);
        }
    };

    private SecureXmlParserFactory() {
    }

    private static DocumentBuilderFactory createDocumentBuilderFactory() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(false);
        dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        dbf.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        return dbf;
    }

    public static DocumentBuilder newDocumentBuilder() {
        try {
            DocumentBuilderFactory dbf = SecureXmlParserFactory.createDocumentBuilderFactory();
            dbf.setNamespaceAware(false);
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private static SAXParserFactory createSAXParseFactory() throws SAXException, ParserConfigurationException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        spf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        return spf;
    }

    private static XMLReader xmlReaderFrom(SAXParserFactory spf) throws SAXException, ParserConfigurationException {
        XMLReader xmlReader = spf.newSAXParser().getXMLReader();
        xmlReader.setEntityResolver(emptyEntityResolver);
        return xmlReader;
    }

    public static XMLReader newXmlReader() {
        try {
            SAXParserFactory spf = SecureXmlParserFactory.createSAXParseFactory();
            spf.setNamespaceAware(false);
            return SecureXmlParserFactory.xmlReaderFrom(spf);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public static XMLReader newNamespaceAwareXmlReader() {
        try {
            SAXParserFactory spf = SecureXmlParserFactory.createSAXParseFactory();
            spf.setNamespaceAware(true);
            return SecureXmlParserFactory.xmlReaderFrom(spf);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public static DocumentBuilder newNamespaceAwareDocumentBuilder() {
        try {
            DocumentBuilderFactory dbf = SecureXmlParserFactory.createDocumentBuilderFactory();
            dbf.setNamespaceAware(true);
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static XMLInputFactory newXmlInputFactory() {
        XMLInputFactory fac = XMLInputFactory.newFactory();
        fac.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        return fac;
    }

    public static EntityResolver emptyEntityResolver() {
        return emptyEntityResolver;
    }
}

