/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.secrets.store.vault;

import com.atlassian.secrets.api.SecretStore;
import com.atlassian.secrets.api.SecretStoreException;
import com.atlassian.secrets.store.vault.VaultParams;
import com.atlassian.secrets.vault.DefaultVaultTemplateFactory;
import com.atlassian.secrets.vault.VaultTemplateFactory;
import com.atlassian.secrets.vault.VaultUtils;
import com.atlassian.secrets.vault.auth.DefaultVaultAuthenticationProvider;
import com.atlassian.secrets.vault.auth.VaultAuthenticationProvider;
import com.atlassian.secrets.vault.auth.VaultConfig;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.vault.core.VaultTemplate;
import org.springframework.vault.support.Versioned;

public class VaultSecretStore
implements SecretStore {
    private static final Logger log = LoggerFactory.getLogger(VaultSecretStore.class);
    private final VaultTemplateFactory templateFactory;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final VaultAuthenticationProvider vaultAuthenticationProvider;

    public VaultSecretStore(VaultTemplateFactory templateFactory, VaultAuthenticationProvider vaultAuthenticationProvider) {
        this.templateFactory = templateFactory;
        this.vaultAuthenticationProvider = vaultAuthenticationProvider;
    }

    public VaultSecretStore() {
        this((VaultTemplateFactory)new DefaultVaultTemplateFactory(), (VaultAuthenticationProvider)new DefaultVaultAuthenticationProvider());
    }

    public String get(String jsonParams) {
        try {
            VaultParams vaultParams = (VaultParams)((Object)this.objectMapper.readValue(jsonParams, VaultParams.class));
            VaultTemplate vaultTemplate = this.templateFactory.getTemplate(URI.create(vaultParams.getEndpoint()), this.vaultAuthenticationProvider.getAuthentication((VaultConfig)vaultParams));
            Versioned readResponse = vaultTemplate.opsForVersionedKeyValue(vaultParams.getMount()).get(vaultParams.getPath());
            log.debug("Retrieved Vault secret: {}", (Object)vaultParams);
            return VaultUtils.getSecretValueFromReadResponse((Versioned)readResponse, (String)vaultParams.getKey());
        }
        catch (JacksonException e) {
            log.error("Problem when reading secret store configuration. Please review the JSON configuration string.");
            throw new SecretStoreException("Problem when reading secret store configuration. Please review the JSON configuration string.");
        }
        catch (Exception e) {
            log.error("Problem when getting the secret value: {}", (Object)e.getMessage());
            throw new SecretStoreException("Problem when getting the secret value", (Throwable)e);
        }
    }

    public String store(String plainTextData) {
        throw new UnsupportedOperationException("Encryption is currently not supported for HashiCorp Vault");
    }
}

