/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.secrets.tomcat.cipher;

import com.atlassian.secrets.api.SecretStoreException;
import com.atlassian.secrets.store.algorithm.serialization.SafeObjectInputStream;
import com.atlassian.secrets.store.algorithm.serialization.SerializationFile;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;

public class SerializationService {
    public <T> void save(String destPath, T object) {
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(Files.newOutputStream(Paths.get(destPath, new String[0]), new OpenOption[0]));){
            objectOutputStream.writeObject(object);
        }
        catch (IOException e) {
            throw new SecretStoreException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T load(String scrPath, Class<T> clazz) {
        try (SafeObjectInputStream objectIn = new SafeObjectInputStream(Files.newInputStream(Paths.get(scrPath, new String[0]), new OpenOption[0]), SerializationFile.DESERIALIZATION_ALLOWED_CLASSES);){
            Object passwordDataBean = objectIn.readObject();
            if (!passwordDataBean.getClass().getCanonicalName().equals(clazz.getCanonicalName())) {
                throw new ClassCastException("Expected: " + clazz + ", got: " + passwordDataBean.getClass());
            }
            Object object = passwordDataBean;
            return (T)object;
        }
        catch (IOException | ClassCastException | ClassNotFoundException e) {
            throw new SecretStoreException((Throwable)e);
        }
    }
}

