/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.scheduler;

import com.atlassian.scheduler.SchedulerUtil;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Category;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;

public class SchedulerLauncher
implements ServletContextListener {
    private static final Category log = Category.getInstance((Class)SchedulerLauncher.class);
    private static final SchedulerUtil schedulerUtil = new SchedulerUtil();

    public void contextInitialized(ServletContextEvent event) {
        log.debug((Object)"Initializing Scheduler Launcher.");
        if (this.canCreateScheduler()) {
            try {
                schedulerUtil.initializeAndStart(this.getScheduler());
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        } else {
            log.info((Object)"The scheduler has not been launched at this time.");
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        log.debug((Object)"Destroying Scheduler Launcher.");
        try {
            schedulerUtil.shutdownScheduler(this.getScheduler());
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    public Scheduler getScheduler() throws SchedulerException {
        return new StdSchedulerFactory().getScheduler();
    }

    protected boolean canCreateScheduler() {
        return true;
    }
}

