/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.scheduler.config;

import com.atlassian.annotations.PublicApi;
import com.atlassian.scheduler.util.Safe;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.base.Objects;
import java.util.Date;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
@PublicApi
public final class IntervalScheduleInfo {
    private final Date firstRunTime;
    private final long intervalInMillis;

    IntervalScheduleInfo(@Nullable Date firstRunTime, long intervalInMillis) {
        this.firstRunTime = Safe.copy(firstRunTime);
        this.intervalInMillis = intervalInMillis;
        Assertions.isTrue((String)"intervalInMillis must not be negative", (intervalInMillis >= 0L ? 1 : 0) != 0);
    }

    @Nullable
    public Date getFirstRunTime() {
        return Safe.copy(this.firstRunTime);
    }

    public long getIntervalInMillis() {
        return this.intervalInMillis;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntervalScheduleInfo other = (IntervalScheduleInfo)o;
        return this.intervalInMillis == other.intervalInMillis && Objects.equal((Object)this.firstRunTime, (Object)other.firstRunTime);
    }

    public int hashCode() {
        int result = this.firstRunTime != null ? this.firstRunTime.hashCode() : 0;
        result = 31 * result + (int)(this.intervalInMillis ^ this.intervalInMillis >>> 32);
        return result;
    }

    public String toString() {
        return "IntervalScheduleInfo[firstRunTime=" + this.firstRunTime + ",intervalInMillis=" + this.intervalInMillis + ']';
    }
}

