/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.api.features;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.sal.api.features.ValidFeatureKeyPredicate;
import com.atlassian.webresource.api.QueryParams;
import com.atlassian.webresource.api.url.UrlBuilder;
import com.atlassian.webresource.spi.condition.UrlReadingCondition;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class DarkFeatureEnabledCondition
implements Condition,
UrlReadingCondition {
    private static final Logger log = LoggerFactory.getLogger(DarkFeatureEnabledCondition.class);
    private static final String FEATURE_KEY_INIT_PARAMETER_NAME = "featureKey";
    @VisibleForTesting
    static final boolean DEFAULT_STATE = false;
    private final DarkFeatureManager darkFeatureManager;
    private String featureKey;

    public DarkFeatureEnabledCondition(DarkFeatureManager darkFeatureManager) {
        this.darkFeatureManager = darkFeatureManager;
    }

    public void init(Map<String, String> params) {
        Objects.requireNonNull(params, "params");
        if (!params.containsKey(FEATURE_KEY_INIT_PARAMETER_NAME)) {
            throw new PluginParseException("Parameter 'featureKey' is mandatory.");
        }
        this.featureKey = ValidFeatureKeyPredicate.checkFeatureKey(params.get(FEATURE_KEY_INIT_PARAMETER_NAME));
    }

    public void addToUrl(UrlBuilder urlBuilder) {
        Objects.requireNonNull(urlBuilder, "urlBuilder");
        urlBuilder.addToQueryString(this.featureKey, Boolean.toString(this.isFeatureEnabled()));
    }

    public boolean shouldDisplay(QueryParams queryParams) {
        Objects.requireNonNull(queryParams, "queryParams");
        String queryParamValue = queryParams.get(this.featureKey);
        if (DarkFeatureEnabledCondition.isBlankOrNull(queryParamValue)) {
            log.trace("In the web-resource URL, the query param <{}> did not have a value, so defaulted to false", (Object)this.featureKey);
            return false;
        }
        return Boolean.parseBoolean(queryParamValue);
    }

    public boolean shouldDisplay(@Nullable Map<String, Object> stringObjectMap) {
        return this.isFeatureEnabled();
    }

    private boolean isFeatureEnabled() {
        try {
            return this.darkFeatureManager.isEnabledForCurrentUser(this.featureKey).orElse(false);
        }
        catch (RuntimeException e) {
            log.trace("Was not able to check if the dark feature <{}> was enabled", (Object)this.featureKey, (Object)e);
            return false;
        }
    }

    private static boolean isBlankOrNull(@Nullable String key) {
        return Objects.isNull(key) || key.trim().isEmpty();
    }
}

