/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.api.features;

import com.atlassian.annotations.PublicApi;
import com.atlassian.sal.api.features.FeatureKeyScope;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;

@Immutable
@PublicApi
public final class EnabledDarkFeatures {
    public static final EnabledDarkFeatures NONE = new EnabledDarkFeatures(Collections.emptyMap());
    private final Map<FeatureKeyScope, Set<String>> enabledFeatures;

    public EnabledDarkFeatures(Map<FeatureKeyScope, Set<String>> enabledFeatures) {
        Objects.requireNonNull(enabledFeatures, "enabledFeatures");
        this.enabledFeatures = Collections.unmodifiableMap(enabledFeatures);
    }

    public Set<String> getFeatureKeySet() {
        return Collections.unmodifiableSet(this.enabledFeatures.values().stream().flatMap(Collection::stream).collect(Collectors.toSet()));
    }

    public Set<String> getFeatureKeys(Predicate<FeatureKeyScope> criteria) {
        Objects.requireNonNull(criteria, "criteria");
        return Collections.unmodifiableSet(this.enabledFeatures.entrySet().stream().filter(entry -> criteria.test((FeatureKeyScope)((Object)entry.getKey()))).map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toSet()));
    }

    public boolean isFeatureEnabled(String featureKey) {
        Objects.requireNonNull(featureKey, "featureKey");
        return this.enabledFeatures.values().stream().anyMatch(set -> set.contains(featureKey));
    }

    public String toString() {
        return "EnabledDarkFeatures{enabledFeatures=" + this.enabledFeatures + '}';
    }
}

