package com.atlassian.sal.api.features;

import java.util.function.Predicate;

import javax.annotation.Nullable;

/**
 * @since 2.10.1
 */
public class FeatureKeyScopePredicate implements com.google.common.base.Predicate<FeatureKeyScope> {
    private final FeatureKeyScope featureKeyScope;

    public FeatureKeyScopePredicate(final FeatureKeyScope featureKeyScope) {
        this.featureKeyScope = featureKeyScope;
    }

    public static FeatureKeyScopePredicate filterBy(final FeatureKeyScope featureKeyScope) {
        return new FeatureKeyScopePredicate(featureKeyScope);
    }

    /**
     * @param input the feature key to be compared.
     * @return whether the input matches the predicate
     * @deprecated since 4.6, use {@link com.atlassian.sal.api.features.FeatureKeyScopePredicate#test(FeatureKeyScope)} instead.
     * This class will stop implementing {@link com.google.common.base.Predicate<FeatureKeyScope>}.
     */
    @Deprecated
    @Override
    public boolean apply(@Nullable final FeatureKeyScope input) {
        return input == featureKeyScope;
    }

    /**
     * @since 4.6.0.
     * @param input the feature key to be compared.
     * @return whether the input matches the predicate
     */
    @Override
    public boolean test(@Nullable final FeatureKeyScope input) {
        return input == featureKeyScope;
    }
}
