package com.atlassian.sal.api.validate;

import com.atlassian.annotations.PublicApi;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

@SuppressWarnings ("UnusedDeclaration")
@PublicApi
/**
 * The outcome of a validation check.
 */
public class ValidationResult
{
    private static final ValidationResult VALID = new ValidationResult(Collections.<String>emptyList());

    private final List<String> errorMessages;

    private ValidationResult(@Nonnull final List<String> errorMessages)
    {
        this.errorMessages = errorMessages;
    }

    public static ValidationResult valid()
    {
        return VALID;
    }

    public static ValidationResult withErrorMessages(List<String> errorMessages)
    {
        if (errorMessages == null)
            return valid();
        return new ValidationResult(errorMessages);
    }

    /**
     * Return true if the validation passed, false if there were errors.
     * <p>
     * Equivalent to <pre>getErrorMessages().size() == 0</pre>
     *
     * @return true if the validation passed, false if there were errors.
     */
    boolean isValid()
    {
        return errorMessages.isEmpty();
    }

    /**
     * Returns the list of validation errors.
     * <p>
     * These should normally be localised to the end user's locale.
     * This will never be null, but may be empty.
     *
     * @return the list of validation errors.
     */
    @Nonnull
    List<String> getErrorMessages()
    {
        return errorMessages;
    }
}
