package com.atlassian.sal.api.license;

import com.atlassian.annotations.PublicApi;

import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * This represents an individual license for the host application.
 *
 * Note that some licenses can include multiple Products in a single license (eg ELAs - Enterprise License Agreements).
 * Other times, a platform may have multiple licenses installed at the same time - one for each Product.
 */
@SuppressWarnings ("UnusedDeclaration")
@PublicApi
public interface MultiProductLicenseDetails extends BaseLicenseDetails
{
    /**
     * Returns the license details for all products that are included in this license for the current platform.
     * <p>
     * eg if this is the JIRA platform, it could return the license details for Service Desk, Software etc.
     *
     * @return all individual Product licenses inside this license String.
     */
    @Nonnull
    Collection<ProductLicense> getAllProductLicenses();

    /**
     * Returns the individual Product license with the given product key.
     *
     * @param productKey the product key.
     *
     * @return the individual Product license with the given product key, or null if that product does not exist in this license.
     */
    @Nullable
    ProductLicense getProductLicense(@Nonnull String productKey);
}
