package com.atlassian.sal.api.lifecycle;

/**
 * Marker interface that indicates a component wishes to execute some code after application startup.
 * <p/>
 * {@link #onStart()} will be invoked:
 * <ol>
 *     <li>immediately after the host application has started up; and</li>
 *     <li>immediately after the host application has been restored from backup (if the host supports backup and restore); and</li>
 *     <li>immediately after a plugin module is enabled, if the plugin is installed or enabled manually after the host application
 *     has already started.</li>
 * </ol>
 * <p/>
 * <strong>Note:</strong> for this to work a component must be exposed as an OSGi service with {@code LifecycleAware} as a declared
 * interface. For transformerless plugins using the atlassian spring scanner, this can be done using the {@code ExportAsService}
 * annotation. For transformed plugins, use a {@code <component>} with a {@code public="true"} attribute and an
 * {@code <interface>com.atlassian.sal.api.lifecycle.LifecycleAware</interface>} child element. For example:
 * <pre>
 *      &lt;component key="my-cool-component" class="com.atlassian.stash.MyCoolComponent" public="true"&gt;
 *          &lt;interface&gt;com.atlassian.sal.api.lifecycle.LifecycleAware&lt;/interface&gt;
 *      &lt;/component&gt;
 * </pre>
 * <p/>
 *
 * @since 2.0
 */
public interface LifecycleAware
{
    /**
     * Notification that the plugin is enabled and the application is started, including  after being restored from backup.
     */
    void onStart();
}
