package com.atlassian.sal.api.license;

import com.atlassian.annotations.PublicApi;

import javax.annotation.Nonnull;

/**
 * Represents license information for an individual role-based "Product" that lives on a platform.
 */
@SuppressWarnings ("UnusedDeclaration")
@PublicApi
public interface ProductLicense
{
    static final int UNLIMITED_USER_COUNT = -1;

    /**
     * Returns the product key as it occurs in the license.
     * <p>eg "com.atlassian.servicedesk", "crucible", "conf"</p>
     *
     * @return the product key
     */
    @Nonnull
    String getProductKey();

    /**
     * Returns true if this license authorises an unlimited number of users.
     *
     * @return true if this license authorises an unlimited number of users.
     *
     * @see #getNumberOfUsers()
     */
    boolean isUnlimitedNumberOfUsers();

    /**
     * Returns the number of users allowed by the current license.
     *
     * @return the number of user allowed by the license, {@link #UNLIMITED_USER_COUNT} if there is no limit
     *
     * @see #isUnlimitedNumberOfUsers()
     */
    int getNumberOfUsers();

    /**
     * Returns the "official" product name as it occurs in the license.
     * <p>
     *     eg "Service Desk"
     * <p>
     *     You would normally try to extract this name from the plugin itself, but this is included as a fallback in
     *     case the license is installed but the plugin is not.
     * <p>
     *     The product name is a trademark and is never internationalised.
     *
     * @return the "official" product name as it occurs in the license.
     */
    @Nonnull
    String getProductDisplayName();
}