package com.atlassian.sal.api.features;

import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;

import java.util.Map;

/**
 * A parameterised plugin module condition for enabling modules in the presence of a dark feature.
 * Pass a param with key "key" containing the dark feature key.
 */
public class DarkFeatureEnabledCondition implements Condition
{
    private final DarkFeatureManager darkFeatureManager;

    private String key;

    public DarkFeatureEnabledCondition(DarkFeatureManager darkFeatureManager)
    {
        this.darkFeatureManager = darkFeatureManager;
    }

    @Override
    public void init(Map<String, String> params) throws PluginParseException
    {
        key = params.get("key");
    }

    @Override
    public boolean shouldDisplay(Map<String, Object> stringObjectMap)
    {
        return key == null || darkFeatureManager.isUserFeatureEnabled(key);
    }
}
