package com.atlassian.sal.api.features;

import com.google.common.base.Predicate;

import javax.annotation.Nullable;

/**
 * @since 2.10
 */
public class FeatureKeyClassifierPredicate implements Predicate<FeatureKeyScope>
{
    private final FeatureKeyScope classifier;

    public FeatureKeyClassifierPredicate(final FeatureKeyScope classifier)
    {
        this.classifier = classifier;
    }

    public static FeatureKeyClassifierPredicate filterBy(final FeatureKeyScope classifier)
    {
        return new FeatureKeyClassifierPredicate(classifier);
    }

    @Override
    public boolean apply(@Nullable final FeatureKeyScope input)
    {
        return input != null && input == classifier;
    }
}
