/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2.components.block;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.TokenType;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.SubRenderer;
import com.atlassian.renderer.v2.components.RendererComponent;
import com.atlassian.renderer.v2.components.block.BlockRenderer;
import com.atlassian.renderer.v2.components.block.LineWalker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class BlockRendererComponent
implements RendererComponent {
    private static final Pattern BLOCK_AND_WHITESPACE_PATTERN = Pattern.compile("(\\s*" + TokenType.BLOCK.getTokenPatternString() + ")+\\s*", 8);
    private static final Pattern INLINE_BLOCK_AND_WHITESPACE_PATTERN = Pattern.compile("(\\s*" + TokenType.INLINE_BLOCK.getTokenPatternString() + ")+\\s*", 8);
    private static final Pattern SINGLE_LINE_PARA = Pattern.compile("\\s*[\\p{Alnum}&&[^PLhb]][^\n]*");
    private static final List<String> LIST_OF_SINGLE_EMPTY_STRING = Collections.singletonList("");
    private BlockRenderer[] blockRenderers;
    private SubRenderer subRenderer;

    public BlockRendererComponent(SubRenderer subRenderer, List<BlockRenderer> blockRenderers) {
        this.subRenderer = subRenderer;
        this.blockRenderers = blockRenderers.toArray(new BlockRenderer[blockRenderers.size()]);
    }

    public void setBlockRenderers(List<BlockRenderer> blockRenderers) {
        this.blockRenderers = blockRenderers.toArray(new BlockRenderer[blockRenderers.size()]);
    }

    @Override
    public boolean shouldRender(RenderMode renderMode) {
        return renderMode.renderParagraphs();
    }

    @Override
    public String render(String wiki, RenderContext context) {
        if (SINGLE_LINE_PARA.matcher(wiki).matches() && !BlockRendererComponent.containsBlockTokens(wiki) && !BlockRendererComponent.containsInlineBlockTokens(wiki)) {
            return context.addRenderedContent(this.renderParagraph(true, context, wiki), TokenType.BLOCK);
        }
        LineWalker walker = new LineWalker(wiki);
        ArrayList<String> renderedLines = new ArrayList<String>();
        ArrayList<String> paragraph = new ArrayList<String>();
        boolean firstPara = true;
        while (walker.hasNext()) {
            String nextLine = walker.next();
            if (firstPara && paragraph.isEmpty() && !context.getRenderMode().renderFirstParagraph() && nextLine.trim().length() == 0) {
                firstPara = false;
                continue;
            }
            String rendered = null;
            if (BlockRendererComponent.isOneBlockToken(nextLine)) {
                rendered = nextLine;
            } else if (BlockRendererComponent.isOneInlineBlockToken(nextLine)) {
                rendered = nextLine;
            } else if (!SINGLE_LINE_PARA.matcher(wiki).matches()) {
                rendered = this.applyBlockRenderers(context, walker, nextLine, rendered);
            }
            if (rendered == null) {
                for (String linePortion : BlockRendererComponent.splitLineByBlockTokens(nextLine)) {
                    if (!TokenType.BLOCK.getTokenPattern().matcher(linePortion).matches()) {
                        paragraph.add(linePortion);
                        continue;
                    }
                    this.flushParagraph(renderedLines, paragraph, context, firstPara);
                    renderedLines.add(linePortion);
                    firstPara = false;
                }
                continue;
            }
            this.flushParagraph(renderedLines, paragraph, context, firstPara);
            renderedLines.add(rendered);
            firstPara = false;
        }
        this.flushParagraph(renderedLines, paragraph, context, firstPara);
        return context.addRenderedContent(StringUtils.join(renderedLines.iterator(), (String)"\n"), TokenType.BLOCK);
    }

    private static boolean isOneBlockToken(String string) {
        return BLOCK_AND_WHITESPACE_PATTERN.matcher(string).matches();
    }

    private static boolean isOneInlineBlockToken(String string) {
        return INLINE_BLOCK_AND_WHITESPACE_PATTERN.matcher(string).matches();
    }

    private static boolean containsBlockTokens(String string) {
        return TokenType.BLOCK.getTokenPattern().matcher(string).find();
    }

    private static boolean containsInlineBlockTokens(String string) {
        return TokenType.INLINE_BLOCK.getTokenPattern().matcher(string).find();
    }

    private String applyBlockRenderers(RenderContext context, LineWalker walker, String nextLine, String rendered) {
        BlockRenderer blockRenderer;
        BlockRenderer[] blockRendererArray = this.blockRenderers;
        int n = blockRendererArray.length;
        for (int i = 0; i < n && (rendered = (blockRenderer = blockRendererArray[i]).renderNextBlock(nextLine, walker, context, this.subRenderer)) == null; ++i) {
        }
        return rendered;
    }

    static List<String> splitLineByBlockTokens(String line) {
        if (line.isEmpty()) {
            return LIST_OF_SINGLE_EMPTY_STRING;
        }
        Matcher matcher = TokenType.BLOCK.getTokenPattern().matcher(line);
        if (!matcher.find()) {
            return Collections.singletonList(line);
        }
        ArrayList<String> result = new ArrayList<String>();
        int mark = 0;
        do {
            int start;
            if ((start = matcher.start()) > mark) {
                result.add(line.substring(mark, matcher.start()));
            }
            result.add(matcher.group());
            mark = matcher.end();
        } while (matcher.find());
        if (line.length() > mark) {
            result.add(line.substring(mark));
        }
        return result;
    }

    private void flushParagraph(List<String> renderedLines, List<String> remainderedLines, RenderContext context, boolean firstParagraph) {
        if (remainderedLines.isEmpty()) {
            return;
        }
        String paragraph = StringUtils.join(remainderedLines.iterator(), (String)"\n");
        renderedLines.add(this.renderParagraph(firstParagraph, context, paragraph));
        remainderedLines.clear();
    }

    private String renderParagraph(boolean firstParagraph, RenderContext context, String paragraph) {
        String inner = this.subRenderer.render(paragraph, context, context.getRenderMode().and(RenderMode.INLINE));
        if (firstParagraph && !context.getRenderMode().renderFirstParagraph()) {
            return inner;
        }
        return "<p>" + inner + "</p>";
    }
}

