/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class TextUtils {
    public static final String[] SINGLE_TAGS = new String[]{"br", "p", "hr"};

    public static boolean stringSet(String string) {
        return string != null && !string.isEmpty();
    }

    public static String noNull(String string, String defaultString) {
        return TextUtils.stringSet(string) ? string : defaultString;
    }

    public static String noNull(String string) {
        return TextUtils.noNull(string, "");
    }

    public static String join(String glue, Iterator pieces) {
        StringBuilder s = new StringBuilder();
        while (pieces.hasNext()) {
            s.append(pieces.next().toString());
            if (!pieces.hasNext()) continue;
            s.append(glue);
        }
        return s.toString();
    }

    public static final String join(String glue, Collection pieces) {
        return TextUtils.join(glue, pieces.iterator());
    }

    public static int parseInt(String in) {
        int i;
        try {
            i = Integer.parseInt(in);
        }
        catch (Exception e) {
            i = (int)TextUtils.parseFloat(in);
        }
        return i;
    }

    public static float parseFloat(String in) {
        float f = 0.0f;
        try {
            f = Float.parseFloat(in);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f;
    }

    public static String trimToEndingChar(String str, int len) {
        boolean inTag = false;
        boolean anyTags = false;
        String result = "";
        int goodChars = 0;
        int lastEndingCharPos = -1;
        if (str.length() < len) {
            return str;
        }
        char[] strA = str.toCharArray();
        for (int i = 0; i < strA.length; ++i) {
            if (strA[i] == '<' && !inTag) {
                anyTags = true;
                inTag = true;
            }
            if (strA[i] == '>' && inTag) {
                inTag = false;
            }
            if (!inTag) {
                if (TextUtils.isEndingChar(strA[i])) {
                    lastEndingCharPos = i;
                }
                ++goodChars;
            }
            result = result + strA[i];
            if (goodChars == len) break;
        }
        if (lastEndingCharPos + 1 != result.length()) {
            if (lastEndingCharPos != -1) {
                result = result.substring(0, lastEndingCharPos + 1);
            } else {
                int spacePos = result.lastIndexOf(32);
                if (spacePos != -1) {
                    result = result.substring(0, spacePos);
                }
            }
        }
        if (anyTags) {
            return TextUtils.closeTags(result);
        }
        return result;
    }

    private static final boolean isEndingChar(char c) {
        return c == '.' || c == '!' || c == ',' || c == '?';
    }

    public static final String closeTags(String str) {
        HashMap<String, Integer> openTags = new HashMap<String, Integer>();
        str = TextUtils.noNull(str, "");
        boolean inTag = false;
        boolean inTagName = false;
        boolean inOpenTag = true;
        String tagName = "";
        List<String> singleTags = Arrays.asList(SINGLE_TAGS);
        char[] strA = str.toCharArray();
        for (int i = 0; i < strA.length; ++i) {
            char c = strA[i];
            if (!inTag) {
                if (c != '<') continue;
                inTag = true;
                inTagName = true;
                inOpenTag = true;
                tagName = "";
                continue;
            }
            if (tagName.length() == 0 && c == '/') {
                inOpenTag = false;
                continue;
            }
            if (inTagName && (c == ' ' || c == '>' || c == '/')) {
                int tagCount;
                inTagName = false;
                if (inOpenTag && !singleTags.contains(tagName.toLowerCase())) {
                    if (openTags.get(tagName) == null) {
                        openTags.put(tagName, new Integer(1));
                    } else {
                        tagCount = (Integer)openTags.get(tagName);
                        openTags.put(tagName, new Integer(tagCount + 1));
                    }
                } else if (openTags.get(tagName) != null) {
                    tagCount = (Integer)openTags.get(tagName);
                    if (tagCount > 1) {
                        openTags.put(tagName, new Integer(tagCount - 1));
                    } else {
                        openTags.remove(tagName);
                    }
                }
                if (c != '>') continue;
                inTag = false;
                continue;
            }
            if (inTagName) {
                tagName = tagName + c;
                continue;
            }
            if (c != '>') continue;
            inTag = false;
        }
        Iterator openTagNames = openTags.keySet().iterator();
        StringBuffer closedString = new StringBuffer(str);
        while (openTagNames.hasNext()) {
            String openTagName = (String)openTagNames.next();
            for (int i = 0; i < (Integer)openTags.get(openTagName); ++i) {
                closedString.append("</").append(openTagName).append('>');
            }
        }
        return closedString.toString();
    }

    public static final String htmlEncode(String s) {
        return TextUtils.htmlEncode(s, true);
    }

    public static final String htmlEncode(String s, boolean encodeSpecialChars) {
        s = TextUtils.noNull(s);
        StringBuffer str = new StringBuffer();
        for (int j = 0; j < s.length(); ++j) {
            char c = s.charAt(j);
            if (c < '\u0080') {
                switch (c) {
                    case '\"': {
                        str.append("&quot;");
                        break;
                    }
                    case '&': {
                        str.append("&amp;");
                        break;
                    }
                    case '<': {
                        str.append("&lt;");
                        break;
                    }
                    case '>': {
                        str.append("&gt;");
                        break;
                    }
                    default: {
                        str.append(c);
                        break;
                    }
                }
                continue;
            }
            if (encodeSpecialChars && c < '\u00ff') {
                String hexChars = "0123456789ABCDEF";
                int a = c % 16;
                int b = (c - a) / 16;
                String hex = "" + hexChars.charAt(b) + hexChars.charAt(a);
                str.append("&#x" + hex + ";");
                continue;
            }
            str.append(c);
        }
        return str.toString();
    }
}

