package com.atlassian.renderer.wysiwyg.converter;

import com.atlassian.renderer.util.NodeUtil;
import com.atlassian.renderer.wysiwyg.NodeContext;
import com.atlassian.renderer.wysiwyg.WikiMarkupEscaper;

class TextConverter implements Converter {
    public static TextConverter INSTANCE = new TextConverter();

    private TextConverter() {
    }

    public boolean canConvert(NodeContext nodeContext) {
        return NodeUtil.isTextNode(nodeContext.getNode());
    }

    public String convertNode(NodeContext nodeContext, DefaultWysiwygConverter wysiwygConverter) {
        if (nodeContext.isIgnoreText())
            return null;

        String s = nodeContext.getNode().getNodeValue();

        if (isWhitespaceOnly(s)) {
            return null;
        }

        s = s.replaceAll("^\n", "");
        s = s.replaceAll("\n$", "");
        s = s.replaceAll("(\n|\r)", " ");
        // todo: determine whether this is actually a good thing.
        // Why do we want to drop whitespace when going to wiki markup?
        // What do we have against whitespace exactly?


        if (s.trim().equals("")) {
            // todo: justify this or remove it.  Sounds bogus to me (donw)
            // blank text should never cause a newline
            return " ";
        }
        StringBuffer sb = new StringBuffer();
        // converts specific space character to generic TEXT_SPEARATOR
        // We don't escape this.  Entering "TEXTSEP" into the RTE results in a space.
        if (s.startsWith(" ")) {
            sb.append(DefaultWysiwygConverter.TEXT_SEPARATOR);
        }
        // todo: Avoid trimming here.
        String sTrimmed = s.trim();
        // todo: Look at removing the call to escapewikiMarkup and instead calling component converters
        if (!DefaultWysiwygConverter.debug) {
            sTrimmed = WikiMarkupEscaper.escapeWikiMarkup(sTrimmed);
        }

        for (com.atlassian.renderer.v2.components.TextConverter textConverter : wysiwygConverter.getTextConverterComponents()) {
            sTrimmed = textConverter.convertToWikiMarkup(sTrimmed);
        }

        sb.append(nodeContext.getStyles().decorateText(sTrimmed));
        if (!s.equals(" ") && s.endsWith(" ")) {
            sb.append(DefaultWysiwygConverter.TEXT_SEPARATOR);
        }
        return wysiwygConverter.getSeparator("text", nodeContext) + replaceEntities(sb.toString());
    }

    /**
     * Returns true if:
     * * This string is empty
     * * the string is empty except for spaces that follow newlines or tabs.
     */
    private boolean isWhitespaceOnly(String string) {
        return string.replaceAll("(\n|\r|\t)+ *", "").length() == 0;
    }

    private String replaceEntities(String s) {
        return s.replaceAll("\\u2014", "---").replaceAll("\\u2013", "--").replaceAll("\\u00A0", "&nbsp;");
    }
}