package com.atlassian.renderer.wysiwyg.converter;

import com.atlassian.renderer.wysiwyg.NodeContext;

/**
 * Converts a preformatted block of code to wiki markup by retrieving the raw child text.
 *
 * @see com.atlassian.renderer.wysiwyg.converter.DefaultWysiwygConverter#getRawChildText(org.w3c.dom.Node, boolean)
 */
final class PreformattingConverter implements Converter {
    static PreformattingConverter INSTANCE = new PreformattingConverter();

    private PreformattingConverter() {
    }

    public boolean canConvert(NodeContext nodeContext) {
        return nodeContext.hasNodeName("pre") || nodeContext.hasNodeName("textarea");
    }

    public String convertNode(NodeContext nodeContext, DefaultWysiwygConverter wysiwygConverter) {
        String separator = wysiwygConverter.getSeparator("pre", nodeContext);
        String convertedChildren = DefaultWysiwygConverter.getRawChildText(nodeContext.getNode(),false);
        return separator + convertedChildren;
    }
}
