package com.atlassian.renderer.wysiwyg.converter;

import com.atlassian.renderer.wysiwyg.NodeContext;
import org.w3c.dom.Node;

/**
 * Converter that creates no wiki markup for the current node but converts the children normally. Also drops the
 * previous sibling, which is used to calculate required newlines.
 */
class IgnoreNodeAndConvertChildText implements Converter {
    public static IgnoreNodeAndConvertChildText INSTANCE = new IgnoreNodeAndConvertChildText();

    private IgnoreNodeAndConvertChildText() {
    }

    public boolean canConvert(NodeContext nodeContext) {
        short nodeType = nodeContext.getNode().getNodeType();
        return nodeType == Node.PROCESSING_INSTRUCTION_NODE
                || nodeType == Node.DOCUMENT_FRAGMENT_NODE;
    }

    public String convertNode(NodeContext nodeContext, DefaultWysiwygConverter wysiwygConverter) {
        NodeContext modifiedContext = new NodeContext.Builder(nodeContext).ignoreText(false).previousSibling(null).build();
        return wysiwygConverter.convertChildren(modifiedContext);
    }
}
