package com.atlassian.renderer.wysiwyg.converter;

import com.atlassian.renderer.wysiwyg.NodeContext;

/**
 * Converter for nodes that add nothing to the wiki markup.  Not even their children
 * are processed.  Currently this is just the {@code link} tag which is used to include
 * stylesheets in html.
 */
final class IgnoreNodeAndChildren implements Converter {
    static IgnoreNodeAndChildren INSTANCE = new IgnoreNodeAndChildren();

    private IgnoreNodeAndChildren() {
    }

    public boolean canConvert(NodeContext nodeContext) {
        return nodeContext.hasNodeName("link");
    }

    public String convertNode(NodeContext nodeContext, DefaultWysiwygConverter wysiwygConverter) {
        return "";
    }
}
