package com.atlassian.renderer.wysiwyg.converter;

import com.atlassian.renderer.wysiwyg.NodeContext;

/**
 * Converts a single type of node (usually but not always according to its name) from xhtml to wiki markup.
 */
interface Converter {

    /**
     * Return true if this converter can convert the given node.
     */
    boolean canConvert(NodeContext nodeContext);

    /**
     * Convert a single Xhtml node to a string.
     */
    String convertNode(NodeContext nodeContext, DefaultWysiwygConverter wysiwygConverter);
}
