package com.atlassian.renderer.wysiwyg.converter;

import com.atlassian.renderer.wysiwyg.NodeContext;

class BreakConverter implements Converter {
    public static BreakConverter INSTANCE = new BreakConverter();

    private BreakConverter() {
    }

    public boolean canConvert(NodeContext nodeContext) {
        return nodeContext.getNode().getNodeName().equalsIgnoreCase("br");
    }

    public String convertNode(NodeContext nodeContext, DefaultWysiwygConverter wysiwygConverter) {
        if (DefaultWysiwygConverter.isForcedNewline(nodeContext.getNode())) {
            return wysiwygConverter.getSeparator("forcedNewline", nodeContext) + "\\\\ ";
        }
        return wysiwygConverter.getSeparator("br", nodeContext);
    }
}