package com.atlassian.renderer.wysiwyg;

import com.atlassian.renderer.wysiwyg.converter.DefaultWysiwygConverter;
import org.w3c.dom.Node;

/**
 * Macros should implement this interface when they want to take full control of
 * converting xhtml to wiki markup and not let the renderer take care of it. This
 * includes converting the top node representing the macro itself as well as its body (child nodes).
 * <p>
 * Note: macros must also put an attribute of wysiwyg="macro:MACRONAME" during rendering in
 * order for it to be invoked during conversion in the {@link DefaultWysiwygConverter}.
 */
public interface WysiwygNodeConverter {
    /**
     * The attribute used to indicate that a WysiwygNodeConverter should be used to convert
     * the html element.
     */
    public static final String WYSIWYG_ATTRIBUTE = "wysiwyg";

    /**
     * Returns the converted wiki markup from the given node and its context parameters.
     */
    String convertXHtmlToWikiMarkup(Node previousSibling, Node node, WysiwygConverter helper, Styles styles,
                                    ListContext listContext, boolean inTable, boolean inListItem, boolean ignoreText);
}
