package com.atlassian.renderer.wysiwyg;

/**
 * Macros should implement this interface if they want to take full control of just converting
 * the body from xhtml to wiki markup. Note that the nodeContext contains the outer node
 * (that represents the macro itself) and its child nodes represent the macro 'body'.
 */
public interface MacroBodyConverter {
    /**
     * Returns the converted wiki markup of the macro body from the given node context.
     */
    String convertXhtmlToWikiMarkup(NodeContext nodeContext, WysiwygConverter wysiwygConverter);
}
