package com.atlassian.renderer.v2.plugin;

import com.atlassian.renderer.v2.components.RendererComponent;

import java.util.Map;

/**
 * Factory for creating an instance of a RendererComponent. Used by the RendererComponentModuleDescriptor
 * to instantiate components that may need complex construction logic.
 */
public interface RendererComponentFactory {
    /**
     * Get an instance of the component. A map of parameters may be supplied to configure the component.
     * The contents and operation of that map are dependent on the factory implementation.
     * <p>
     * <p>Whether the component returned is a new instance or not is also up to the factory implementation.
     *
     * @param parameters a map of implementation-specific parameters
     * @return an instance of the component to be created
     */
    RendererComponent getComponentInstance(Map parameters);
}
