package com.atlassian.renderer.v2.macro.code.formatter;

public class YamlFormatter extends AbstractFormatter {
    private static final String NUMBERS = "([0-9]+)";
    private static final String KEYS = "([a-zA-Z0-9]+\\:)\\s{1}";
    private static final String KEYS_REPLACEMENT = "<span class=\"code-keyword\">$1 </span>";
    private static final String[] SUPPORTED_LANGUAGES = new String[]{"yaml"};

    public YamlFormatter() {
        addReplacement(DQUOTES, QUOTES_REPLACEMENT);
        addReplacement(SQUOTES, QUOTES_REPLACEMENT);
        addReplacement(NUMBERS, OBJECT_REPLACEMENT);
        addReplacement(KEYS, KEYS_REPLACEMENT);
        addReplacement(HASH_COMMENTS, COMMENTS_REPLACEMENT);
    }

    @Override
    public String[] getSupportedLanguages() {
        return SUPPORTED_LANGUAGES;
    }
}