package com.atlassian.renderer.v2.macro.code.formatter;

public class GroovyFormatter extends AbstractFormatter {
    private static final String KEYWORDS = individualWords(new String[]{
            "as", "assert", "break", "case", "catch", CLASS, "const", "continue", "def", "default",
            "do", "else", "enum", "extends", "false", "finally", "for", "goto", "if", "implements",
            "import", "in", "instanceof", "interface", "new", "null", "package", "return", "super",
            "switch", "this", "throw", "throws", "trait", "true", "try", "while"
    });

    // From JavaFormatter
    private static final String OBJECTS = individualWords(new String[]{
            "Boolean", "Byte", "Character", "Class", "ClassLoader", "Cloneable", "Compiler", "Double",
            "Float", "Integer", "Long", "Math", "Number", "Object", "Process", "Runnable", "Runtime",
            "SecurityManager", "Short", "String", "StringBuffer", "System", "Thread", "ThreadGroup",
            "Void", "boolean", "char", "byte", "short", "int", "long", "float", "double"
    });

    private static final String[] SUPPORTED_LANGUAGES = new String[]{"groovy"};

    public GroovyFormatter() {
        addReplacement(DQUOTES, QUOTES_REPLACEMENT);
        addReplacement(SQUOTES, QUOTES_REPLACEMENT);
        addReplacement(SLASH_COMMENTS, COMMENTS_REPLACEMENT);
        addReplacement(C_COMMENTS, COMMENTS_REPLACEMENT);
        addReplacement(KEYWORDS, KEYWORD_REPLACEMENT);
        addReplacement(OBJECTS, OBJECT_REPLACEMENT);
    }

    @Override
    public String[] getSupportedLanguages() {
        return SUPPORTED_LANGUAGES;
    }
}