package com.atlassian.renderer.v2.macro.code.formatter;

public class ApplescriptFormatter extends AbstractFormatter {
    private static final String KEYWORDS = individualWords(new String[]{
            "about", "above", "after", "against", "and", "apart", "around", "as", "aside", "at",
            "back", "before", "beginning", "behind", "below", "beneath", "beside", "between", "but",
            "by", "considering", "contain", "contains", "continue", "copy", "div", "does", "eighth",
            "else", "end", "equal", "equals", "error", "every", "exit", "false", "fifth", "first",
            "for", "fourth", "from", "front", "get", "given", "global", "if", "ignoring", "in",
            "instead", "into", "is", "it", "its", "last", "local", "me", "middle", "mod", "my",
            "ninth", "not", "of", "on", "onto", "or", "out", "over", "prop", "property", "put", "ref",
            "reference", "repeat", "return", "returning", "script", "second", "set", "seventh",
            "since", "sixth", "some", "tell", "tenth", "that", "the", "then", "third", "through",
            "thru", "timeout", "times", "to", "transaction", "true", "try", "until", "use", "where",
            "while", "whose", "with", "without"
    });

    private static final String[] SUPPORTED_LANGUAGES = new String[]{"applescript"};

    public ApplescriptFormatter() {
        addReplacement(DQUOTES, QUOTES_REPLACEMENT);
        addReplacement(SQUOTES, QUOTES_REPLACEMENT);
        addReplacement(DASH_COMMENTS, COMMENTS_REPLACEMENT);
        addReplacement(KEYWORDS, KEYWORD_REPLACEMENT);
    }

    @Override
    public String[] getSupportedLanguages() {
        return SUPPORTED_LANGUAGES;
    }
}