package com.atlassian.renderer.v2.macro.code;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class SimpleSourceCodeFormatterRepository implements SourceCodeFormatterRepository {
    private Map<String, SourceCodeFormatter> formatters = new TreeMap<String, SourceCodeFormatter>();

    public SimpleSourceCodeFormatterRepository() {
    }

    public SimpleSourceCodeFormatterRepository(List<SourceCodeFormatter> formatters) {
        setCodeFormatters(formatters);
    }

    public SourceCodeFormatter getSourceCodeFormatter(String language) {
        return formatters.get(language);
    }

    public Collection getAvailableLanguages() {
        return Collections.unmodifiableSet(formatters.keySet());
    }

    private void setCodeFormatters(List<SourceCodeFormatter> codeFormatters) {
        formatters.clear();

        for (SourceCodeFormatter formatter : codeFormatters) {
            for (String language : formatter.getSupportedLanguages()) {
                formatters.put(language, formatter);
            }
        }

    }
}
