package com.atlassian.renderer.v2.macro.basic.validator;

import com.atlassian.renderer.v2.macro.basic.CssSizeValue;
import org.apache.commons.lang.StringUtils;

/**
 * Validates that a parameter is a valid CSS2 size value. It validates for a number, optionally followed
 * by 'px', 'pt' or 'em'.
 */
public class CssSizeValidator implements ParameterValidator {
    private static final CssSizeValidator INSTANCE = new CssSizeValidator();

    private CssSizeValidator() {
    }

    public static CssSizeValidator getInstance() {
        return INSTANCE;
    }

    public void assertValid(String propertyValue) throws MacroParameterValidationException {
        if (StringUtils.isBlank(propertyValue)) return;

        CssSizeValue sizeValue = new CssSizeValue(propertyValue);

        if (!sizeValue.isValid())
            throw new MacroParameterValidationException("Size parameter must be a number (optionally followed by 'px', 'pt' or 'em').");
    }
}
