/*
 * Created by IntelliJ IDEA.
 * User: Mike
 * Date: Oct 28, 2004
 * Time: 1:34:28 PM
 */
package com.atlassian.renderer.v2.components;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.TokenType;
import com.atlassian.renderer.links.GenericLinkParser;
import com.atlassian.renderer.links.Link;
import com.atlassian.renderer.links.LinkResolver;
import com.atlassian.renderer.links.UnpermittedLink;
import com.atlassian.renderer.links.UnresolvedLink;
import com.atlassian.renderer.links.UrlLink;
import com.atlassian.renderer.util.UrlUtil;
import com.atlassian.renderer.v2.RenderMode;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UrlRendererComponent extends AbstractNoTokenRegexRendererComponent {
    /**
     * @deprecated since 7.1 - This field was not encapsulated to guard it against
     * inappropriate manipulation by external code.  It is no longer used.
     */
    @Deprecated
    public static Pattern URL_PATTERN = null;

    /**
     * @deprecated since 7.1 - This field was not encapsulated to guard it against
     * inappropriate manipulation by external code.  It is no longer used.
     */
    @Deprecated
    public static String PURE_URL_PATTERN = null;

    /**
     * @deprecated since 7.1 - This field was not encapsulated to guard it against
     * inappropriate manipulation by external code.  It is no longer used.
     */
    @Deprecated
    public static final char[] INVALID_END_CHARS = {'.', ',', '>', ')', ']', ';', '}', '"', '\'', '!'};


    static final Pattern PATTERN;
    static final Pattern PATTERN_WITH_EMBED;

    static {
        final StringBuilder sb = new StringBuilder("(?<![\\p{Alnum}])((");
        for (String protocol : UrlUtil.URL_PROTOCOLS) {
            sb.append(protocol).append('|');
        }
        sb.setLength(sb.length() - 1);  // drop last '|'
        sb.append(")([-_.!~*';/?:@#&=%+$,\\p{Alnum}\\[\\]\\(\\)\\\\])+)");
        final String regex = sb.toString();
        PATTERN = Pattern.compile("([^\"\\[\\|'!]|^)" + regex);
        PATTERN_WITH_EMBED = Pattern.compile(regex + "|" + AbstractEmbeddedRendererComponent.buildPhraseRegExp("\\!", "\\!"));

        PURE_URL_PATTERN = regex;
        URL_PATTERN = PATTERN;
    }

    private LinkResolver linkResolver;

    public UrlRendererComponent(LinkResolver linkResolver) {
        this.linkResolver = linkResolver;
    }

    public boolean shouldRender(RenderMode renderMode) {
        return renderMode.renderLinks();
    }

    public String render(String wiki, RenderContext context) {
        return (wiki.indexOf(':') == -1) ? wiki : regexRender(wiki, context, PATTERN);
    }

    public void appendSubstitution(StringBuffer buffer, RenderContext context, Matcher matcher) {

        final String url = matcher.group(2);
        final int urlLen = url.length();

        // Rewind until the last char is acceptable...
        int len = urlLen;
        while (len > 0 && isBadEndChar(url.charAt(len - 1))) {
            --len;
        }

        final String fixedUrl = url.substring(0, len);
        final Link link = linkResolver.createLink(context, fixedUrl);

        buffer.append(matcher.group(1));
        buffer.append(context.addRenderedContent(handleUrlLink(link, context, fixedUrl), TokenType.INLINE));

        // Copy any bad chars that were leftover ...
        if (urlLen > len) {
            buffer.append(url, len, urlLen);
        }
    }

    private static boolean isBadEndChar(final char c) {
        switch (c) {
            case '.':
            case ',':
            case '>':
            case ')':
            case ']':
            case ';':
            case '}':
            case '"':
            case '\'':
            case '!':
                return true;
        }
        return false;
    }

    public String handleUrlLink(Link link, RenderContext renderContext, String url) {
        renderContext.addExternalReference(new UrlLink(new GenericLinkParser(url)));
        if (link instanceof UnresolvedLink || link instanceof UnpermittedLink) {
            return url;
        }
        return renderContext.getLinkRenderer().renderLink(link, renderContext);
    }
}