package com.atlassian.renderer.util;

/**
 * Various tools used to escape in wiki markup various potentially harmful unicode characters
 * Example: bidi characters in code blocks.
 */
public interface UnicodeEscapingTool {

    /**
     * Escape bidi character that may be used to obscure malicious code
     * @param text text to be escaped
     * @return text with escaped bidi characters
     */
    String escapeBidiCharacters(String text);
}
