package com.atlassian.renderer.embedded;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.components.HtmlEscaper;
import org.apache.commons.lang.StringUtils;

/**
 * Currently we cannot convert the HTML used to show an embedded flash/movie file back into wiki format.
 * Hence we are using this place holder renderer to render a place holder image in place of the actual animation/movie
 * This will fix CONF-4415
 */
public class PlaceholderImageRenderer implements EmbeddedResourceRenderer {
    /**
     * Key of the parameter to add to the {@link RenderContext} via
     * {@link RenderContext#addParam(Object, Object)} for the image that will be used in
     * place of movies and missing attachment files in the RTE.  This will be appended to
     * {@link RenderContext#getImagePath()} and embedded in an image tag.
     */
    public static final String ICON_PARAMETER = "com.atlassian.renderer.embedded.placeholder.image.name";

    /**
     * The default image that will appear in the img tag created if {@link #ICON_PARAMETER} is not specified.
     */
    public static final String DEFAULT_ICON_NAME = "/icons/attachments/image.gif";

    public PlaceholderImageRenderer() {
    }

    public String renderResource(EmbeddedResource resource, RenderContext context) {
        String iconName = (String) context.getParam(ICON_PARAMETER);
        if (iconName == null)
            iconName = DEFAULT_ICON_NAME;
        String iconPath = context.getImagePath() + iconName;

        String widthValue = resource.getProperties().getProperty("width");
        String widthStr = StringUtils.isBlank(widthValue) ? "" : "width=\"" + widthValue + "\" ";
        String heightValue = resource.getProperties().getProperty("height");
        String heightStr = StringUtils.isBlank(heightValue) ? "" : "height=\"" + heightValue + "\" ";
        return context.addRenderedContent("<img src=\"" + iconPath + "\" " + widthStr + heightStr +
                "imagetext=\"" + HtmlEscaper.escapeAll(resource.getOriginalLinkText(), true) + "\"/>");
    }
}
